/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.lighting;

import codechicken.core.colour.Colour;
import codechicken.core.colour.ColourRGBA;
import codechicken.core.render.CCModel;
import codechicken.core.render.CCRenderState;
import codechicken.core.render.IVertexModifier;
import codechicken.core.render.UV;
import codechicken.core.vec.Vector3;

public class PlanarLightModel
implements IVertexModifier {
    public ColourRGBA[] colours = new ColourRGBA[6];

    public PlanarLightModel(int[] colours) {
        int i = 0;
        while (i < 6) {
            this.colours[i] = new ColourRGBA(colours[i]);
            ++i;
        }
    }

    @Override
    public void applyModifiers(CCModel m, bgd tess, Vector3 vec, UV uv, Vector3 normal, int i) {
        ColourRGBA light = this.colours[CCModel.findSide(normal)];
        int colour = m == null || m.colours == null ? -1 : m.colours[i];
        Colour res = new ColourRGBA(colour).multiply(light);
        CCRenderState.vertexColour(res.r & 0xFF, res.g & 0xFF, res.b & 0xFF, res.a & 0xFF);
    }

    @Override
    public boolean needsNormals() {
        return true;
    }
}

