/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.inventory;

import codechicken.core.inventory.InventoryRange;
import codechicken.core.vec.Vector3;
import com.google.common.base.Objects;
import net.minecraftforge.common.ForgeDirection;

public class InventoryUtils {
    public static final ForgeDirection[] chestSides = new ForgeDirection[]{ForgeDirection.WEST, ForgeDirection.EAST, ForgeDirection.NORTH, ForgeDirection.SOUTH};

    public static wm decrStackSize(lt inv, int slot, int size) {
        wm item = inv.a(slot);
        if (item != null) {
            if (item.a <= size) {
                wm itemstack = item;
                inv.a(slot, null);
                inv.k_();
                return itemstack;
            }
            wm itemstack1 = item.a(size);
            if (item.a == 0) {
                inv.a(slot, null);
            }
            inv.k_();
            return itemstack1;
        }
        return null;
    }

    public static wm getStackInSlotOnClosing(lt inv, int slot) {
        wm stack = inv.a(slot);
        inv.a(slot, null);
        return stack;
    }

    public static int incrStackSize(wm base, wm addition) {
        if (InventoryUtils.canStack(base, addition)) {
            return InventoryUtils.incrStackSize(base, addition.a);
        }
        return 0;
    }

    public static int incrStackSize(wm base, int addition) {
        int totalSize = base.a + addition;
        if (totalSize <= base.e()) {
            return addition;
        }
        if (base.a < base.e()) {
            return base.e() - base.a;
        }
        return 0;
    }

    public static ca writeItemStacksToTag(wm[] items) {
        return InventoryUtils.writeItemStacksToTag(items, 64);
    }

    public static ca writeItemStacksToTag(wm[] items, int maxQuantity) {
        ca tagList = new ca();
        int i = 0;
        while (i < items.length) {
            if (items[i] != null) {
                bs tag = new bs();
                tag.a("Slot", (short)i);
                items[i].b(tag);
                if (maxQuantity > Short.MAX_VALUE) {
                    tag.a("Quantity", items[i].a);
                } else if (maxQuantity > 127) {
                    tag.a("Quantity", (short)items[i].a);
                }
                tagList.a((cf)tag);
            }
            ++i;
        }
        return tagList;
    }

    public static void readItemStacksFromTag(wm[] items, ca tagList) {
        int i = 0;
        while (i < tagList.c()) {
            bs tag = (bs)tagList.b(i);
            short b = tag.d("Slot");
            items[b] = wm.a((bs)tag);
            if (tag.b("Quantity")) {
                cf qtag = tag.a("Quantity");
                if (qtag instanceof bz) {
                    items[b].a = ((bz)qtag).a;
                } else if (qtag instanceof cd) {
                    items[b].a = ((cd)qtag).a;
                }
            }
            ++i;
        }
    }

    public static void dropItem(wm stack, aab world, Vector3 dropLocation) {
        rh item = new rh(world, dropLocation.x, dropLocation.y, dropLocation.z, stack);
        item.x = world.s.nextGaussian() * 0.05;
        item.y = world.s.nextGaussian() * 0.05 + (double)0.2f;
        item.z = world.s.nextGaussian() * 0.05;
        world.d((mp)item);
    }

    public static wm copyStack(wm stack, int quantity) {
        if (stack == null) {
            return null;
        }
        stack = stack.m();
        stack.a = quantity;
        return stack;
    }

    public static boolean areStacksSameTypeCrafting(wm stack1, wm stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        return stack1.c == stack2.c && (stack1.k() == stack2.k() || stack1.k() == -1 || stack2.k() == -1 || stack1.b().o());
    }

    public static int getInsertableQuantity(InventoryRange inv, wm stack) {
        int quantity = 0;
        stack = InventoryUtils.copyStack(stack, Integer.MAX_VALUE);
        int[] nArray = inv.slots;
        int n = inv.slots.length;
        int n2 = 0;
        while (n2 < n) {
            int slot = nArray[n2];
            quantity += InventoryUtils.fitStackInSlot(inv, slot, stack);
            ++n2;
        }
        return quantity;
    }

    public static int fitStackInSlot(InventoryRange inv, int slot, wm stack) {
        wm base = inv.inv.a(slot);
        if (!InventoryUtils.canStack(base, stack) || !inv.canInsertItem(slot, stack)) {
            return 0;
        }
        int fit = base != null ? InventoryUtils.incrStackSize(base, inv.inv.d() - base.a) : inv.inv.d();
        return Math.min(fit, stack.a);
    }

    public static boolean mergeItemStack(InventoryRange inv, wm stack, boolean doMerge) {
        if (doMerge && !InventoryUtils.mergeItemStack(inv, stack, false)) {
            return false;
        }
        stack = stack.m();
        int pass = 0;
        while (pass < 2) {
            int[] nArray = inv.slots;
            int n = inv.slots.length;
            int n2 = 0;
            while (n2 < n) {
                int slot = nArray[n2];
                wm base = inv.inv.a(slot);
                int fit = InventoryUtils.fitStackInSlot(inv, slot, stack);
                if (fit != 0) {
                    if (base != null) {
                        stack.a -= fit;
                        if (doMerge) {
                            base.a += fit;
                            inv.inv.a(slot, base);
                        }
                    } else if (pass == 1) {
                        if (doMerge) {
                            inv.inv.a(slot, InventoryUtils.copyStack(stack, fit));
                        }
                        stack.a -= fit;
                    }
                    if (stack.a == 0) {
                        return true;
                    }
                }
                ++n2;
            }
            ++pass;
        }
        return false;
    }

    public static boolean areStacksIdentical(wm stack1, wm stack2) {
        if (stack1 == null || stack2 == null) {
            return stack1 == stack2;
        }
        return stack1.c == stack2.c && stack1.k() == stack2.k() && stack1.a == stack2.a && Objects.equal((Object)stack1.q(), (Object)stack2.q());
    }

    public static lt getInventory(aab world, int x, int y2, int z2) {
        aqp tile = world.r(x, y2, z2);
        if (!(tile instanceof lt)) {
            return null;
        }
        if (tile instanceof apy) {
            return InventoryUtils.getChest((apy)tile);
        }
        return (lt)tile;
    }

    public static lt getChest(apy chest) {
        ForgeDirection[] forgeDirectionArray = chestSides;
        int n = chestSides.length;
        int n2 = 0;
        while (n2 < n) {
            ForgeDirection fside = forgeDirectionArray[n2];
            if (chest.k.a(chest.l + fside.offsetX, chest.m + fside.offsetY, chest.n + fside.offsetZ) == chest.q().cz) {
                return new ls("container.chestDouble", (lt)((apy)chest.k.r(chest.l + fside.offsetX, chest.m + fside.offsetY, chest.n + fside.offsetZ)), (lt)chest);
            }
            ++n2;
        }
        return chest;
    }

    public static boolean canStack(wm stack1, wm stack2) {
        return stack1 == null || stack2 == null || stack1.c == stack2.c && (!stack2.h() || stack2.k() == stack1.k()) && wm.a((wm)stack2, (wm)stack1) && stack1.f();
    }

    public static void consumeItem(lt inv, int slot) {
        wm stack = inv.a(slot);
        wk item = stack.b();
        if (item.t()) {
            wm container = item.getContainerItemStack(stack);
            inv.a(slot, container);
        } else {
            inv.a(slot, 1);
        }
    }

    public static int stackSize(lt inv, int slot) {
        wm stack = inv.a(slot);
        return stack == null ? 0 : stack.a;
    }

    public static wm getRemovableStack(InventoryRange inv, int slot) {
        wm stack = inv.inv.a(slot);
        if (stack == null || !inv.canExtractItem(slot, stack)) {
            return null;
        }
        return stack;
    }

    public static void dropOnClose(sq player, lt inv) {
        int i = 0;
        while (i < inv.j_()) {
            wm stack = inv.b(i);
            if (stack != null) {
                player.c(stack);
            }
            ++i;
        }
    }

    public static int actualDamage(wm stack) {
        return wk.o.getDamage(stack);
    }
}

