/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.data;

import codechicken.core.data.MCDataOutput;
import codechicken.core.vec.BlockCoord;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraftforge.liquids.LiquidStack;

public class MCOutputStreamWrapper
implements MCDataOutput {
    public DataOutputStream dataout;

    public MCOutputStreamWrapper(DataOutputStream out) {
        this.dataout = out;
    }

    @Override
    public MCOutputStreamWrapper writeBoolean(boolean b) {
        try {
            this.dataout.writeBoolean(b);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCOutputStreamWrapper writeByte(int b) {
        try {
            this.dataout.writeByte(b);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCOutputStreamWrapper writeShort(int s) {
        try {
            this.dataout.writeShort(s);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCOutputStreamWrapper writeInt(int i) {
        try {
            this.dataout.writeInt(i);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCOutputStreamWrapper writeFloat(float f) {
        try {
            this.dataout.writeFloat(f);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCOutputStreamWrapper writeDouble(double d) {
        try {
            this.dataout.writeDouble(d);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCOutputStreamWrapper writeLong(long l) {
        try {
            this.dataout.writeLong(l);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCOutputStreamWrapper writeChar(char c) {
        try {
            this.dataout.writeChar(c);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCOutputStreamWrapper writeByteArray(byte[] barray) {
        try {
            this.dataout.write(barray);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCOutputStreamWrapper writeCoord(int x, int y2, int z2) {
        this.writeInt(x);
        this.writeInt(y2);
        this.writeInt(z2);
        return this;
    }

    @Override
    public MCOutputStreamWrapper writeCoord(BlockCoord coord) {
        this.writeInt(coord.x);
        this.writeInt(coord.y);
        this.writeInt(coord.z);
        return this;
    }

    @Override
    public MCOutputStreamWrapper writeString(String s) {
        try {
            if (s.length() > 65535) {
                throw new IOException("String length: " + s.length() + "too long.");
            }
            this.dataout.writeShort(s.length());
            this.dataout.writeChars(s);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCOutputStreamWrapper writeItemStack(wm stack) {
        this.writeItemStack(stack, false);
        return this;
    }

    public MCOutputStreamWrapper writeItemStack(wm stack, boolean large) {
        if (stack == null) {
            this.writeShort(-1);
        } else {
            this.writeShort(stack.c);
            if (large) {
                this.writeInt(stack.a);
            } else {
                this.writeByte(stack.a);
            }
            this.writeShort(stack.k());
            this.writeNBTTagCompound(stack.d);
        }
        return this;
    }

    @Override
    public MCOutputStreamWrapper writeNBTTagCompound(bs compound) {
        try {
            if (compound == null) {
                this.writeShort(-1);
            } else {
                byte[] var3 = cc.a((bs)compound);
                this.writeShort((short)var3.length);
                this.writeByteArray(var3);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCOutputStreamWrapper writeLiquidStack(LiquidStack liquid) {
        if (liquid == null) {
            this.writeShort(-1);
        } else {
            this.writeShort(liquid.itemID);
            this.writeInt(liquid.amount);
            this.writeShort(liquid.itemMeta);
        }
        return this;
    }
}

