/*
 * Decompiled with CFR 0.152.
 */
package sm0keysa1m0n.skinfixer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.UUID;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;

public class SkinManager {
    private static final String PROFILE_URL = "https://api.mojang.com/profiles/minecraft";
    private static final JsonParser jsonParser = new JsonParser();
    private static HashMap playerUUIDMapping = new HashMap();

    @ForgeSubscribe
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.entity instanceof sq) {
            sq player = (sq)event.entity;
            if (player.bS != null && !player.bS.isEmpty()) {
                player.cv = SkinManager.getSkinUrl(player.bS);
                player.cw = SkinManager.getCapeUrl(player.bS);
                System.out.println("Custom skins set");
            }
        }
    }

    public static String getSkinUrl(String username) {
        return String.format("https://crafatar.com/skins/%s.png", SkinManager.getPlayerUUID(username));
    }

    public static String getCapeUrl(String username) {
        return String.format("https://crafatar.com/capes/%s.png", SkinManager.getPlayerUUID(username));
    }

    public static UUID getPlayerUUID(String username) {
        if (!playerUUIDMapping.containsKey(username)) {
            try {
                URL url = new URL(PROFILE_URL);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setUseCaches(false);
                connection.setDoInput(true);
                connection.setDoOutput(true);
                String body = "[\"" + username + "\"]";
                OutputStream stream = connection.getOutputStream();
                stream.write(body.getBytes());
                stream.flush();
                stream.close();
                JsonArray array = (JsonArray)jsonParser.parse(new InputStreamReader(connection.getInputStream()));
                for (JsonElement profile : array) {
                    JsonObject jsonProfile = (JsonObject)profile;
                    playerUUIDMapping.put(username, SkinManager.getUUIDFromString(jsonProfile.get("id").getAsString()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return (UUID)playerUUIDMapping.get(username);
    }

    private static UUID getUUIDFromString(String id) {
        return UUID.fromString(id.substring(0, 8) + "-" + id.substring(8, 12) + "-" + id.substring(12, 16) + "-" + id.substring(16, 20) + "-" + id.substring(20, 32));
    }
}

