/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.triggers;

import buildcraft.api.gates.ITriggerParameter;
import buildcraft.core.triggers.BCTrigger;
import buildcraft.core.utils.StringUtils;
import buildcraft.transport.EntityData;
import buildcraft.transport.ITriggerPipe;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.PipeTransportLiquids;
import buildcraft.transport.PipeTransportPower;
import buildcraft.transport.pipes.PipePowerWood;
import java.util.Iterator;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;

public class TriggerPipeContents
extends BCTrigger
implements ITriggerPipe {
    Kind kind;

    public TriggerPipeContents(int id, Kind kind) {
        super(id);
        this.kind = kind;
    }

    @Override
    public boolean hasParameter() {
        switch (this.kind) {
            case ContainsItems: 
            case ContainsLiquids: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getDescription() {
        switch (this.kind) {
            case Empty: {
                return StringUtils.localize("gate.pipe.empty");
            }
            case ContainsItems: {
                return StringUtils.localize("gate.pipe.containsItems");
            }
            case ContainsLiquids: {
                return StringUtils.localize("gate.pipe.containsLiquids");
            }
            case ContainsEnergy: {
                return StringUtils.localize("gate.pipe.containsEnergy");
            }
            case RequestsEnergy: {
                return StringUtils.localize("gate.pipe.requestsEnergy");
            }
            case TooMuchEnergy: {
                return StringUtils.localize("gate.pipe.tooMuchEnergy");
            }
        }
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isTriggerActive(Pipe pipe, ITriggerParameter parameter) {
        if (pipe.transport instanceof PipeTransportItems) {
            PipeTransportItems transportItems = (PipeTransportItems)pipe.transport;
            if (this.kind == Kind.Empty) {
                return transportItems.travelingEntities.isEmpty();
            }
            if (this.kind != Kind.ContainsItems) return false;
            if (parameter != null && parameter.getItem() != null) {
                EntityData data;
                Iterator<EntityData> iterator = transportItems.travelingEntities.values().iterator();
                do {
                    if (!iterator.hasNext()) return false;
                    data = iterator.next();
                } while (data.item.getItemStack().field_77993_c != parameter.getItem().field_77993_c || data.item.getItemStack().func_77960_j() != parameter.getItem().func_77960_j());
                return true;
            }
            if (transportItems.travelingEntities.isEmpty()) return false;
            return true;
        }
        if (pipe.transport instanceof PipeTransportLiquids) {
            PipeTransportLiquids transportLiquids = (PipeTransportLiquids)pipe.transport;
            LiquidStack searchedLiquid = null;
            if (parameter != null && parameter.getItem() != null) {
                searchedLiquid = LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)parameter.getItem());
            }
            if (this.kind == Kind.Empty) {
                ILiquidTank[] iLiquidTankArray = transportLiquids.getTanks(ForgeDirection.UNKNOWN);
                int n = iLiquidTankArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ILiquidTank b = iLiquidTankArray[n2];
                    if (b.getLiquid() != null && b.getLiquid().amount != 0) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
            ILiquidTank[] iLiquidTankArray = transportLiquids.getTanks(ForgeDirection.UNKNOWN);
            int n = iLiquidTankArray.length;
            int n3 = 0;
            while (n3 < n) {
                ILiquidTank b = iLiquidTankArray[n3];
                if (b.getLiquid() != null && b.getLiquid().amount != 0) {
                    if (searchedLiquid == null) return true;
                    if (searchedLiquid.isLiquidEqual(b.getLiquid())) {
                        return true;
                    }
                }
                ++n3;
            }
            return false;
        }
        if (!(pipe.transport instanceof PipeTransportPower)) return false;
        PipeTransportPower transportPower = (PipeTransportPower)pipe.transport;
        switch (this.kind) {
            case Empty: {
                double[] searchedLiquid = transportPower.displayPower;
                int n = searchedLiquid.length;
                int n4 = 0;
                while (n4 < n) {
                    double s = searchedLiquid[n4];
                    if (s > 0.0) {
                        return false;
                    }
                    ++n4;
                }
                return true;
            }
            case ContainsEnergy: {
                double[] searchedLiquid = transportPower.displayPower;
                int n = searchedLiquid.length;
                int n5 = 0;
                while (n5 < n) {
                    double s = searchedLiquid[n5];
                    if (s > 0.0) {
                        return true;
                    }
                    ++n5;
                }
                return false;
            }
            case RequestsEnergy: {
                PipePowerWood wood = (PipePowerWood)pipe;
                return wood.requestsPower();
            }
        }
        return transportPower.isOverloaded();
    }

    @Override
    public int getIconIndex() {
        switch (this.kind) {
            case Empty: {
                return 17;
            }
            case ContainsItems: {
                return 18;
            }
            case ContainsLiquids: {
                return 19;
            }
            case ContainsEnergy: {
                return 20;
            }
            case RequestsEnergy: {
                return 31;
            }
        }
        return 32;
    }

    public static enum Kind {
        Empty,
        ContainsItems,
        ContainsLiquids,
        ContainsEnergy,
        RequestsEnergy,
        TooMuchEnergy;

    }
}

