/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.Position;
import buildcraft.api.transport.IPipeTile;
import buildcraft.transport.IPipeTransportLiquidsFilterDirectionsHook;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportLiquids;
import buildcraft.transport.pipes.PipeLogicClay;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;

public class PipeLiquidsClay
extends Pipe
implements IPipeTransportLiquidsFilterDirectionsHook {
    public PipeLiquidsClay(int itemID) {
        super(new PipeTransportLiquids(), new PipeLogicClay(), itemID);
        ((PipeTransportLiquids)this.transport).flowRate = (short)20;
        ((PipeTransportLiquids)this.transport).travelDelay = (short)6;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        return 39;
    }

    @Override
    public List<ForgeDirection> filterPossibleMovements(List<ForgeDirection> possibleOrientations, Position pos, LiquidStack resource) {
        LinkedList<ForgeDirection> nonPipesList = new LinkedList<ForgeDirection>();
        LinkedList<ForgeDirection> pipesList = new LinkedList<ForgeDirection>();
        for (ForgeDirection o : possibleOrientations) {
            int filled;
            TileEntity entity;
            if (!this.container.pipe.outputOpen(o) || !this.container.isPipeConnected(o) || !((entity = this.container.getTile(o)) instanceof ITankContainer) || (filled = ((ITankContainer)entity).fill(o.getOpposite(), resource, false)) <= 0) continue;
            if (entity instanceof IPipeTile) {
                pipesList.add(o);
                continue;
            }
            nonPipesList.add(o);
        }
        return nonPipesList.isEmpty() ? pipesList : nonPipesList;
    }
}

