/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.Position;
import buildcraft.api.transport.IPipedItem;
import buildcraft.core.utils.Utils;
import buildcraft.transport.IPipeTransportItemsHook;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.pipes.PipeLogicStone;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import net.minecraftforge.common.ForgeDirection;

public class PipeItemsStone
extends Pipe
implements IPipeTransportItemsHook {
    public PipeItemsStone(int itemID) {
        super(new PipeTransportItems(), new PipeLogicStone(), itemID);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        return 18;
    }

    @Override
    public void readjustSpeed(IPipedItem item) {
        if (item.getSpeed() > Utils.pipeNormalSpeed) {
            item.setSpeed(item.getSpeed() - Utils.pipeNormalSpeed / 2.0f);
        }
        if (item.getSpeed() < Utils.pipeNormalSpeed) {
            item.setSpeed(Utils.pipeNormalSpeed);
        }
    }

    @Override
    public LinkedList<ForgeDirection> filterPossibleMovements(LinkedList<ForgeDirection> possibleOrientations, Position pos, IPipedItem item) {
        return possibleOrientations;
    }

    @Override
    public void entityEntered(IPipedItem item, ForgeDirection orientation) {
    }
}

