/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.Position;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.IPipedItem;
import buildcraft.transport.IPipeTransportItemsHook;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.pipes.PipeLogicClay;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class PipeItemsClay
extends Pipe
implements IPipeTransportItemsHook {
    public PipeItemsClay(int itemID) {
        super(new PipeTransportItems(), new PipeLogicClay(), itemID);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        return 39;
    }

    @Override
    public LinkedList<ForgeDirection> filterPossibleMovements(LinkedList<ForgeDirection> possibleOrientations, Position pos, IPipedItem item) {
        LinkedList<ForgeDirection> nonPipesList = new LinkedList<ForgeDirection>();
        LinkedList<ForgeDirection> pipesList = new LinkedList<ForgeDirection>();
        for (ForgeDirection o : possibleOrientations) {
            if (!this.container.pipe.outputOpen(o) || !this.container.isPipeConnected(o)) continue;
            TileEntity entity = this.container.getTile(o);
            if (entity instanceof IPipeTile) {
                pipesList.add(o);
                continue;
            }
            nonPipesList.add(o);
        }
        return nonPipesList.isEmpty() ? pipesList : nonPipesList;
    }

    @Override
    public void entityEntered(IPipedItem item, ForgeDirection orientation) {
    }

    @Override
    public void readjustSpeed(IPipedItem item) {
    }
}

