/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.Position;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.inventory.ISpecialInventory;
import buildcraft.api.transport.IPipeEntry;
import buildcraft.api.transport.IPipedItem;
import buildcraft.core.DefaultProps;
import buildcraft.core.EntityPassiveItem;
import buildcraft.core.IMachine;
import buildcraft.core.inventory.Transactor;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.BlockUtil;
import buildcraft.core.utils.Utils;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.EntityData;
import buildcraft.transport.IItemTravelingHook;
import buildcraft.transport.IPipeTransportItemsHook;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.network.PacketPipeTransportContent;
import buildcraft.transport.network.PacketPipeTransportNBT;
import buildcraft.transport.network.PacketSimpleId;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class PipeTransportItems
extends PipeTransport {
    public boolean allowBouncing = false;
    public Map<Integer, EntityData> travelingEntities = new HashMap<Integer, EntityData>();
    private final List<EntityData> entitiesToLoad = new LinkedList<EntityData>();
    private final List<EntityData> delayedEntitiesToLoad = new LinkedList<EntityData>();
    private int delay = -1;
    public IItemTravelingHook travelHook;
    Set<Integer> toRemove = new HashSet<Integer>();

    public void readjustSpeed(IPipedItem item) {
        if (this.container.pipe instanceof IPipeTransportItemsHook) {
            ((IPipeTransportItemsHook)((Object)this.container.pipe)).readjustSpeed(item);
        } else {
            this.defaultReajustSpeed(item);
        }
    }

    public void defaultReajustSpeed(IPipedItem item) {
        float speed = item.getSpeed();
        if (speed > Utils.pipeNormalSpeed) {
            speed -= Utils.pipeNormalSpeed;
        }
        if (speed < Utils.pipeNormalSpeed) {
            speed = Utils.pipeNormalSpeed;
        }
        item.setSpeed(speed);
    }

    @Override
    public void entityEntering(IPipedItem item, ForgeDirection orientation) {
        if (item.isCorrupted()) {
            return;
        }
        this.readjustSpeed(item);
        EntityData data = this.travelingEntities.get(item.getEntityId());
        if (data == null) {
            data = new EntityData(item, orientation);
            this.travelingEntities.put(item.getEntityId(), data);
            if (item.getContainer() != null && item.getContainer() != this.container) {
                ((PipeTransportItems)((TileGenericPipe)item.getContainer()).pipe.transport).scheduleRemoval(item);
            }
            item.setContainer(this.container);
        }
        if (orientation != ForgeDirection.UP && orientation != ForgeDirection.DOWN) {
            item.setPosition(item.getPosition().x, (float)this.yCoord + Utils.getPipeFloorOf(item.getItemStack()), item.getPosition().z);
        }
        if (!this.worldObj.field_72995_K) {
            data.output = this.resolveDestination(data);
        }
        if (this.container.pipe instanceof IPipeTransportItemsHook) {
            ((IPipeTransportItemsHook)((Object)this.container.pipe)).entityEntered(item, orientation);
        }
        if (!this.worldObj.field_72995_K) {
            this.sendItemPacket(data);
        }
        if (!this.worldObj.field_72995_K && this.travelingEntities.size() > BuildCraftTransport.groupItemsTrigger) {
            this.groupEntities();
            if (this.travelingEntities.size() > BuildCraftTransport.maxItemsInPipes) {
                BlockUtil.explodeBlock(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
                return;
            }
        }
    }

    protected void reverseItem(EntityData data) {
        if (data.item.isCorrupted()) {
            return;
        }
        this.unscheduleRemoval(data.item);
        data.toCenter = true;
        data.input = data.output.getOpposite();
        this.readjustSpeed(data.item);
        if (data.input != ForgeDirection.UP && data.input != ForgeDirection.DOWN) {
            data.item.setPosition(data.item.getPosition().x, (float)this.yCoord + Utils.getPipeFloorOf(data.item.getItemStack()), data.item.getPosition().z);
        }
        if (!this.worldObj.field_72995_K) {
            data.output = this.resolveDestination(data);
        }
        if (this.container.pipe instanceof IPipeTransportItemsHook) {
            ((IPipeTransportItemsHook)((Object)this.container.pipe)).entityEntered(data.item, data.input);
        }
        if (!this.worldObj.field_72995_K) {
            this.sendItemPacket(data);
        }
    }

    public ForgeDirection resolveDestination(EntityData data) {
        LinkedList<ForgeDirection> listOfPossibleMovements = this.getPossibleMovements(data);
        if (listOfPossibleMovements.size() == 0) {
            return ForgeDirection.UNKNOWN;
        }
        int i = this.worldObj.field_73012_v.nextInt(listOfPossibleMovements.size());
        return listOfPossibleMovements.get(i);
    }

    public LinkedList<ForgeDirection> getPossibleMovements(EntityData data) {
        LinkedList<ForgeDirection> result = new LinkedList<ForgeDirection>();
        data.blacklist.add(data.input.getOpposite());
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            if (data.blacklist.contains(o) || !this.container.pipe.outputOpen(o) || !this.canReceivePipeObjects(o, data.item)) continue;
            result.add(o);
        }
        if (result.size() == 0 && this.allowBouncing && this.canReceivePipeObjects(data.input.getOpposite(), data.item)) {
            result.add(data.input.getOpposite());
        }
        if (this.container.pipe instanceof IPipeTransportItemsHook) {
            Position pos = new Position(this.xCoord, this.yCoord, this.zCoord, data.input);
            result = ((IPipeTransportItemsHook)((Object)this.container.pipe)).filterPossibleMovements(result, pos, data.item);
        }
        return result;
    }

    public boolean canReceivePipeObjects(ForgeDirection o, IPipedItem item) {
        TileEntity entity = this.container.getTile(o);
        if (!Utils.checkPipesConnections(entity, this.container)) {
            return false;
        }
        if (entity instanceof IPipeEntry) {
            return true;
        }
        if (entity instanceof TileGenericPipe) {
            TileGenericPipe pipe = (TileGenericPipe)entity;
            return pipe.pipe.transport instanceof PipeTransportItems;
        }
        return entity instanceof IInventory && Transactor.getTransactorFor((Object)entity).add((ItemStack)item.getItemStack(), (ForgeDirection)o.getOpposite(), (boolean)false).field_77994_a > 0;
    }

    @Override
    public void updateEntity() {
        this.moveSolids();
    }

    public void scheduleRemoval(IPipedItem item) {
        this.toRemove.add(item.getEntityId());
    }

    public void unscheduleRemoval(IPipedItem item) {
        this.toRemove.remove(item.getEntityId());
    }

    public void performRemoval() {
        this.travelingEntities.keySet().removeAll(this.toRemove);
        this.toRemove.clear();
    }

    private void moveSolids() {
        if (this.delay > 0) {
            --this.delay;
            if (this.delay == 0) {
                this.entitiesToLoad.addAll(this.delayedEntitiesToLoad);
                this.delayedEntitiesToLoad.clear();
                this.delay = -1;
            }
        }
        if (!this.entitiesToLoad.isEmpty()) {
            for (EntityData data : this.entitiesToLoad) {
                data.item.setWorld(this.worldObj);
                this.travelingEntities.put(data.item.getEntityId(), data);
            }
            this.entitiesToLoad.clear();
        }
        this.performRemoval();
        for (EntityData data : this.travelingEntities.values()) {
            if (data.item.isCorrupted()) {
                this.scheduleRemoval(data.item);
                data.item.remove();
                continue;
            }
            Position motion = new Position(0.0, 0.0, 0.0, data.toCenter ? data.input : data.output);
            motion.moveForwards(data.item.getSpeed());
            Position pos = data.item.getPosition();
            data.item.setPosition(pos.x + motion.x, pos.y + motion.y, pos.z + motion.z);
            pos = data.item.getPosition();
            if (data.toCenter && this.middleReached(data, pos) || this.outOfBounds(pos)) {
                data.toCenter = false;
                data.item.setPosition((double)this.xCoord + 0.5, (float)this.yCoord + Utils.getPipeFloorOf(data.item.getItemStack()), (double)this.zCoord + 0.5);
                if (data.output == ForgeDirection.UNKNOWN) {
                    if (this.travelHook != null) {
                        this.travelHook.drop(this, data);
                    }
                    EntityItem dropped = null;
                    if (!this.toRemove.contains(data.item.getEntityId())) {
                        dropped = data.item.toEntityItem(data.input);
                    }
                    this.scheduleRemoval(data.item);
                    if (dropped == null) continue;
                    this.onDropped(dropped);
                    continue;
                }
                if (this.travelHook == null) continue;
                this.travelHook.centerReached(this, data);
                continue;
            }
            if (data.toCenter || !this.endReached(pos)) continue;
            TileEntity tile = this.container.getTile(data.output);
            if (this.travelHook != null) {
                this.travelHook.endReached(this, data, tile);
            }
            if (this.toRemove.contains(data.item.getEntityId())) continue;
            this.scheduleRemoval(data.item);
            this.handleTileReached(data, tile);
        }
        this.performRemoval();
    }

    private void handleTileReached(EntityData data, TileEntity tile) {
        if (tile instanceof IPipeEntry) {
            ((IPipeEntry)tile).entityEntering(data.item, data.output);
        } else if (tile instanceof TileGenericPipe && ((TileGenericPipe)tile).pipe.transport instanceof PipeTransportItems) {
            TileGenericPipe pipe = (TileGenericPipe)tile;
            ((PipeTransportItems)pipe.pipe.transport).entityEntering(data.item, data.output);
        } else if (tile instanceof IInventory) {
            if (!CoreProxy.proxy.isRenderWorld(this.worldObj)) {
                ItemStack added = Transactor.getTransactorFor(tile).add(data.item.getItemStack(), data.output.getOpposite(), true);
                data.item.getItemStack().field_77994_a -= added.field_77994_a;
                if (data.item.getItemStack().field_77994_a > 0) {
                    this.reverseItem(data);
                }
            }
        } else {
            EntityItem dropped;
            if (this.travelHook != null) {
                this.travelHook.drop(this, data);
            }
            if ((dropped = data.item.toEntityItem(data.output)) != null) {
                this.onDropped(dropped);
            }
        }
    }

    protected boolean middleReached(EntityData entity, Position pos) {
        float middleLimit = entity.item.getSpeed() * 1.01f;
        return Math.abs((double)this.xCoord + 0.5 - pos.x) < (double)middleLimit && Math.abs((double)((float)this.yCoord + Utils.getPipeFloorOf(entity.item.getItemStack())) - pos.y) < (double)middleLimit && Math.abs((double)this.zCoord + 0.5 - pos.z) < (double)middleLimit;
    }

    protected boolean endReached(Position pos) {
        return pos.x > (double)(this.xCoord + 1) || pos.x < (double)this.xCoord || pos.y > (double)(this.yCoord + 1) || pos.y < (double)this.yCoord || pos.z > (double)(this.zCoord + 1) || pos.z < (double)this.zCoord;
    }

    protected boolean outOfBounds(Position pos) {
        return pos.x > (double)(this.xCoord + 2) || pos.x < (double)(this.xCoord - 1) || pos.y > (double)(this.yCoord + 2) || pos.y < (double)(this.yCoord - 1) || pos.z > (double)(this.zCoord + 2) || pos.z < (double)(this.zCoord - 1);
    }

    public Position getPosition() {
        return new Position(this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        NBTTagList nbttaglist = nbt.func_74761_m("travelingEntities");
        for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
            try {
                NBTTagCompound dataTag = (NBTTagCompound)nbttaglist.func_74743_b(j);
                EntityPassiveItem entity = new EntityPassiveItem(null);
                entity.readFromNBT(dataTag);
                if (entity.isCorrupted()) {
                    entity.remove();
                    continue;
                }
                entity.setContainer(this.container);
                EntityData data = new EntityData(entity, ForgeDirection.getOrientation((int)dataTag.func_74762_e("input")));
                data.output = ForgeDirection.getOrientation((int)dataTag.func_74762_e("output"));
                data.toCenter = dataTag.func_74767_n("toCenter");
                this.delayedEntitiesToLoad.add(data);
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        this.delay = 2;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        NBTTagList nbttaglist = new NBTTagList();
        for (EntityData data : this.travelingEntities.values()) {
            NBTTagCompound dataTag = new NBTTagCompound();
            nbttaglist.func_74742_a((NBTBase)dataTag);
            data.item.writeToNBT(dataTag);
            dataTag.func_74757_a("toCenter", data.toCenter);
            dataTag.func_74768_a("input", data.input.ordinal());
            dataTag.func_74768_a("output", data.output.ordinal());
        }
        nbt.func_74782_a("travelingEntities", (NBTBase)nbttaglist);
    }

    protected void doWork() {
    }

    public void handleItemPacket(PacketPipeTransportContent packet) {
        if (packet.getID() != 2) {
            return;
        }
        EntityData data = this.travelingEntities.remove(packet.getEntityId());
        IPipedItem item = data == null ? EntityPassiveItem.getOrCreate(this.worldObj, packet.getEntityId()) : data.item;
        if (item.getItemStack() == null) {
            item.setItemStack(new ItemStack(packet.getItemId(), packet.getStackSize(), packet.getItemDamage()));
            if (packet.hasNBT()) {
                PacketDispatcher.sendPacketToServer((Packet)new PacketSimpleId(5, this.xCoord, this.yCoord, this.zCoord, packet.getEntityId()).getPacket());
            }
        } else if (item.getItemStack().field_77993_c != packet.getItemId() || item.getItemStack().field_77994_a != packet.getStackSize() || item.getItemStack().func_77960_j() != packet.getItemDamage() || item.getItemStack().func_77942_o() != packet.hasNBT()) {
            item.setItemStack(new ItemStack(packet.getItemId(), packet.getStackSize(), packet.getItemDamage()));
            if (packet.hasNBT()) {
                PacketDispatcher.sendPacketToServer((Packet)new PacketSimpleId(5, this.xCoord, this.yCoord, this.zCoord, packet.getEntityId()).getPacket());
            }
        }
        if (item.getPosition() == null) {
            item.setPosition(packet.getPosX(), packet.getPosY(), packet.getPosZ());
        }
        item.setSpeed(packet.getSpeed());
        if (item.getContainer() != null && item.getContainer() != this.container) {
            ((PipeTransportItems)((TileGenericPipe)item.getContainer()).pipe.transport).scheduleRemoval(item);
            item.setContainer(this.container);
        }
        data = new EntityData(item, packet.getInputOrientation());
        data.output = packet.getOutputOrientation();
        this.travelingEntities.put(item.getEntityId(), data);
    }

    public void handleNBTRequestPacket(EntityPlayer player, int entityId) {
        EntityData data = this.travelingEntities.get(entityId);
        if (data == null || data.item == null || data.item.getItemStack() == null) {
            return;
        }
        PacketDispatcher.sendPacketToPlayer((Packet)new PacketPipeTransportNBT(6, this.xCoord, this.yCoord, this.zCoord, entityId, data.item.getItemStack().func_77978_p()).getPacket(), (Player)((Player)player));
    }

    public void handleNBTPacket(PacketPipeTransportNBT packet) {
        EntityData data = this.travelingEntities.get(packet.getEntityId());
        if (data == null || data.item == null || data.item.getItemStack() == null) {
            return;
        }
        data.item.getItemStack().func_77982_d(packet.getTagCompound());
    }

    public Packet createItemPacket(EntityData data) {
        PacketPipeTransportContent packet = new PacketPipeTransportContent(data);
        return packet.getPacket();
    }

    private void sendItemPacket(EntityData data) {
        int dimension = this.worldObj.field_73011_w.field_76574_g;
        PacketDispatcher.sendPacketToAllAround((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, (double)DefaultProps.PIPE_CONTENTS_RENDER_DIST, (int)dimension, (Packet)this.createItemPacket(data));
    }

    public int getNumberOfItems() {
        return this.travelingEntities.size();
    }

    public void onDropped(EntityItem item) {
        this.container.pipe.onDropped(item);
    }

    protected void neighborChange() {
    }

    @Override
    public boolean canPipeConnect(TileEntity tile, ForgeDirection side) {
        Pipe pipe2;
        if (tile instanceof TileGenericPipe && BlockGenericPipe.isValid(pipe2 = ((TileGenericPipe)tile).pipe) && !(pipe2.transport instanceof PipeTransportItems)) {
            return false;
        }
        return tile instanceof TileGenericPipe || tile instanceof IPipeEntry || tile instanceof ISpecialInventory || tile instanceof IInventory && ((IInventory)tile).func_70302_i_() > 0 || tile instanceof IMachine && ((IMachine)tile).manageSolids();
    }

    @Override
    public boolean acceptItems() {
        return true;
    }

    public boolean isTriggerActive(ITrigger trigger) {
        return false;
    }

    public void groupEntities() {
        ArrayList<EntityData> entities = new ArrayList<EntityData>();
        for (EntityData entityData : this.travelingEntities.values()) {
            if (entityData.item.hasContributions() || entityData.item.getItemStack().field_77994_a >= entityData.item.getItemStack().func_77976_d()) continue;
            entities.add(entityData);
        }
        if (entities.isEmpty()) {
            return;
        }
        Collections.sort(entities, new Comparator<EntityData>(){

            @Override
            public int compare(EntityData a, EntityData b) {
                int itemA = a.item.getItemStack().field_77993_c << 16 | a.item.getItemStack().func_77960_j();
                int itemB = b.item.getItemStack().field_77993_c << 16 | b.item.getItemStack().func_77960_j();
                return itemA - itemB;
            }
        });
        int matchStart = 0;
        int lastId = ((EntityData)entities.get((int)0)).item.getItemStack().field_77993_c << 16 | ((EntityData)entities.get((int)0)).item.getItemStack().func_77960_j();
        for (int i = 1; i < entities.size(); ++i) {
            int id = ((EntityData)entities.get((int)i)).item.getItemStack().field_77993_c << 16 | ((EntityData)entities.get((int)i)).item.getItemStack().func_77960_j();
            if (id == lastId) continue;
            this.groupEntityRange(entities, matchStart, i);
            matchStart = i;
            lastId = id;
        }
        this.groupEntityRange(entities, matchStart, entities.size());
    }

    private void groupEntityRange(List<EntityData> entities, int start, int end) {
        block0: for (int j = start; j < end; ++j) {
            EntityData target = entities.get(j);
            if (target == null) continue;
            for (int k = j + 1; k < end; ++k) {
                EntityData source = entities.get(k);
                if (source == null || !ItemStack.func_77970_a((ItemStack)source.item.getItemStack(), (ItemStack)target.item.getItemStack())) continue;
                int amount = source.item.getItemStack().field_77994_a;
                int space = target.item.getItemStack().func_77976_d() - target.item.getItemStack().field_77994_a;
                if (amount <= space) {
                    target.item.getItemStack().field_77994_a += amount;
                    source.item.remove();
                    this.travelingEntities.remove(source.item.getEntityId());
                    entities.set(k, null);
                } else {
                    target.item.getItemStack().field_77994_a += space;
                    source.item.getItemStack().field_77994_a -= space;
                }
                if (amount >= space) continue block0;
            }
        }
    }

    @Override
    public void dropContents() {
        this.groupEntities();
        for (EntityData data : this.travelingEntities.values()) {
            Utils.dropItems(this.worldObj, data.item.getItemStack(), this.xCoord, this.yCoord, this.zCoord);
        }
        this.travelingEntities.clear();
    }

    @Override
    public boolean delveIntoUnloadedChunks() {
        return true;
    }
}

