/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftTransport;
import buildcraft.api.recipes.AssemblyRecipe;
import buildcraft.core.CreativeTabBuildCraft;
import buildcraft.core.ItemBuildCraft;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.transport.TileGenericPipe;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class ItemFacade
extends ItemBuildCraft {
    public static final LinkedList<ItemStack> allFacades = new LinkedList();
    private static final ItemStack NO_MATCH = new ItemStack(0, 0, 0);

    public ItemFacade(int i) {
        super(i);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77637_a(CreativeTabBuildCraft.tabBuildCraft);
    }

    @Override
    public String func_77628_j(ItemStack itemstack) {
        String name = super.func_77628_j(itemstack);
        int decodedBlockId = ItemFacade.getBlockId(itemstack);
        int decodedMeta = ItemFacade.getMetaData(itemstack);
        if (decodedBlockId < Block.field_71973_m.length && Block.field_71973_m[decodedBlockId] != null && Block.field_71973_m[decodedBlockId].func_71857_b() == 31) {
            decodedMeta &= 3;
        }
        ItemStack newStack = new ItemStack(decodedBlockId, 1, decodedMeta);
        name = Item.field_77698_e[decodedBlockId] != null ? name + ": " + CoreProxy.proxy.getItemDisplayName(newStack) : name + " < BROKEN (" + decodedBlockId + ":" + decodedMeta + " )>";
        return name;
    }

    public String func_77667_c(ItemStack itemstack) {
        return "item.Facade";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77633_a(int par1, CreativeTabs par2CreativeTabs, List itemList) {
        for (ItemStack stack : allFacades) {
            itemList.add(stack.func_77946_l());
        }
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World worldObj, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (worldObj.field_72995_K) {
            return false;
        }
        TileEntity tile = worldObj.func_72796_p(x, y, z);
        if (!(tile instanceof TileGenericPipe)) {
            return false;
        }
        TileGenericPipe pipeTile = (TileGenericPipe)tile;
        if (player.func_70093_af()) {
            if (!pipeTile.hasFacade(ForgeDirection.VALID_DIRECTIONS[side])) {
                return false;
            }
            pipeTile.dropFacade(ForgeDirection.VALID_DIRECTIONS[side]);
            return true;
        }
        if (((TileGenericPipe)tile).addFacade(ForgeDirection.values()[side], ItemFacade.getBlockId(stack), ItemFacade.getMetaData(stack))) {
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            return true;
        }
        return false;
    }

    public static void initialize() {
        for (Field f : Block.class.getDeclaredFields()) {
            Block b;
            if (!Modifier.isStatic(f.getModifiers()) || !Block.class.isAssignableFrom(f.getType())) continue;
            try {
                b = (Block)f.get(null);
            }
            catch (Exception e) {
                continue;
            }
            if (b.field_71990_ca != 20 && (b.field_71990_ca == 7 || b.field_71990_ca == 2 || b.field_71990_ca == 18 || b.field_71990_ca == 19 || b.field_71990_ca == 95 || !b.func_71926_d() || b.hasTileEntity(0) || !b.func_71886_c())) continue;
            ItemStack base = new ItemStack(b, 1);
            if (base.func_77981_g()) {
                HashSet names = Sets.newHashSet();
                for (int meta = 0; meta <= 15; ++meta) {
                    ItemStack is = new ItemStack(b, 1, meta);
                    if (Strings.isNullOrEmpty((String)is.func_77977_a()) || !names.add(is.func_77977_a())) continue;
                    ItemFacade.addFacade(is);
                }
                continue;
            }
            ItemFacade.addFacade(base);
        }
    }

    public static int getMetaData(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("meta")) {
            return stack.func_77978_p().func_74762_e("meta");
        }
        return stack.func_77960_j() & 0xF;
    }

    public static int getBlockId(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("id")) {
            return stack.func_77978_p().func_74762_e("id");
        }
        return (stack.func_77960_j() & 0xFFF0) >>> 4;
    }

    public boolean shouldPassSneakingClickToBlock(World worldObj, int x, int y, int z) {
        return true;
    }

    public static void addFacade(ItemStack itemStack) {
        Block bl;
        ItemStack facade = ItemFacade.getStack(itemStack.field_77993_c, itemStack.func_77960_j());
        allFacades.add(facade);
        ItemStack facade6 = facade.func_77946_l();
        facade6.field_77994_a = 6;
        AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new ItemStack[]{new ItemStack(BuildCraftTransport.pipeStructureCobblestone, 3), itemStack}, 8000, facade6));
        if (itemStack.field_77993_c < Block.field_71973_m.length && Block.field_71973_m[itemStack.field_77993_c] != null && (bl = Block.field_71973_m[itemStack.field_77993_c]).func_71857_b() == 31) {
            ItemStack rotLog1 = ItemFacade.getStack(itemStack.field_77993_c, itemStack.func_77960_j() | 4);
            ItemStack rotLog2 = ItemFacade.getStack(itemStack.field_77993_c, itemStack.func_77960_j() | 8);
            allFacades.add(rotLog1);
            allFacades.add(rotLog2);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister par1IconRegister) {
    }

    @SideOnly(value=Side.CLIENT)
    public int func_94901_k() {
        return 0;
    }

    public static ItemStack getStack(int blockID, int metadata) {
        ItemStack stack = new ItemStack((Item)BuildCraftTransport.facadeItem, 1, 0);
        NBTTagCompound nbt = new NBTTagCompound("tag");
        nbt.func_74768_a("meta", metadata);
        nbt.func_74768_a("id", blockID);
        stack.func_77982_d(nbt);
        return stack;
    }

    public class FacadeRecipe
    implements IRecipe {
        public boolean func_77569_a(InventoryCrafting inventorycrafting, World world) {
            ItemStack slotmatch = null;
            for (int i = 0; i < inventorycrafting.func_70302_i_(); ++i) {
                ItemStack slot = inventorycrafting.func_70301_a(i);
                if (slot != null && slot.field_77993_c == ItemFacade.this.field_77779_bT && slotmatch == null) {
                    slotmatch = slot;
                    continue;
                }
                if (slot == null) continue;
                slotmatch = NO_MATCH;
            }
            if (slotmatch != null && slotmatch != NO_MATCH) {
                int blockId = ItemFacade.getBlockId(slotmatch);
                return blockId < Block.field_71973_m.length && Block.field_71973_m[blockId] != null && Block.field_71973_m[blockId].func_71857_b() == 31;
            }
            return false;
        }

        public ItemStack func_77572_b(InventoryCrafting inventorycrafting) {
            ItemStack slotmatch = null;
            for (int i = 0; i < inventorycrafting.func_70302_i_(); ++i) {
                ItemStack slot = inventorycrafting.func_70301_a(i);
                if (slot != null && slot.field_77993_c == ItemFacade.this.field_77779_bT && slotmatch == null) {
                    slotmatch = slot;
                    continue;
                }
                if (slot == null) continue;
                slotmatch = NO_MATCH;
            }
            if (slotmatch != null && slotmatch != NO_MATCH) {
                int blockId = ItemFacade.getBlockId(slotmatch);
                int blockMeta = ItemFacade.getMetaData(slotmatch);
                if (blockId >= Block.field_71973_m.length) {
                    return null;
                }
                Block bl = Block.field_71973_m[blockId];
                if (bl != null && bl.func_71857_b() == 31 && (blockMeta & 0xC) == 0) {
                    return ItemFacade.getStack(blockId, blockMeta & 3 | 4);
                }
                if (bl != null && bl.func_71857_b() == 31 && (blockMeta & 8) == 0) {
                    return ItemFacade.getStack(blockId, blockMeta & 3 | 8);
                }
                if (bl != null && bl.func_71857_b() == 31 && (blockMeta & 4) == 0) {
                    return ItemFacade.getStack(blockId, blockMeta & 3);
                }
            }
            return null;
        }

        public int func_77570_a() {
            return 1;
        }

        public ItemStack func_77571_b() {
            return null;
        }
    }
}

