/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.api.core.IIconProvider;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.gates.ITriggerParameter;
import com.google.common.base.Throwables;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Method;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public class FallbackWrapper
implements ITrigger {
    private ITrigger brokenInstance;
    private Method iconMethod;
    private Method activeMethod;

    public FallbackWrapper(ITrigger wrap) {
        try {
            this.iconMethod = wrap.getClass().getDeclaredMethod("getTextureIcon", new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.activeMethod = wrap.getClass().getDeclaredMethod("isTriggerActive", TileEntity.class, ITriggerParameter.class);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        this.brokenInstance = wrap;
    }

    @Override
    public int getId() {
        return this.brokenInstance.getId();
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIcon() {
        try {
            return (Icon)this.iconMethod.invoke((Object)this.brokenInstance, new Object[0]);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public int getIconIndex() {
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return this.brokenInstance.getIconProvider();
    }

    @Override
    public boolean hasParameter() {
        return this.brokenInstance.hasParameter();
    }

    @Override
    public String getDescription() {
        return this.brokenInstance.getDescription();
    }

    @Override
    public boolean isTriggerActive(ForgeDirection side, TileEntity tile, ITriggerParameter parameter) {
        try {
            return (Boolean)this.activeMethod.invoke((Object)this.brokenInstance, tile, parameter);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public ITriggerParameter createParameter() {
        return this.brokenInstance.createParameter();
    }

    public boolean equals(Object obj) {
        return this.brokenInstance.equals(obj);
    }

    public int hashCode() {
        return this.brokenInstance.hashCode();
    }
}

