/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftTransport;
import buildcraft.api.tools.IToolWrench;
import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.ISolidSideTile;
import buildcraft.core.BlockIndex;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.Utils;
import buildcraft.transport.GateVanilla;
import buildcraft.transport.IPipeRenderState;
import buildcraft.transport.ItemPipe;
import buildcraft.transport.Pipe;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.TransportProxy;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockGenericPipe
extends BlockContainer {
    private static Random rand = new Random();
    private boolean skippedFirstIconRegister;
    public static Map<Integer, Class<? extends Pipe>> pipes = new HashMap<Integer, Class<? extends Pipe>>();
    static long lastRemovedDate = -1L;
    public static Map<BlockIndex, Pipe> pipeRemoved = new HashMap<BlockIndex, Pipe>();
    public static int facadeRenderColor = -1;

    public BlockGenericPipe(int i) {
        super(i, Material.field_76264_q);
    }

    public float func_71934_m(World par1World, int par2, int par3, int par4) {
        return BuildCraftTransport.pipeDurability;
    }

    public int func_71857_b() {
        return TransportProxy.pipeModel;
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean canBeReplacedByLeaves(World world, int x, int y, int z) {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof ISolidSideTile) {
            return ((ISolidSideTile)tile).isSolidOnSide(side);
        }
        return false;
    }

    public boolean isACube() {
        return false;
    }

    public void func_71871_a(World world, int i, int j, int k, AxisAlignedBB axisalignedbb, List arraylist, Entity par7Entity) {
        this.func_71905_a(0.25f, 0.25f, 0.25f, 0.75f, 0.75f, 0.75f);
        super.func_71871_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
        TileEntity tile1 = world.func_72796_p(i, j, k);
        TileGenericPipe tileG = (TileGenericPipe)tile1;
        if (Utils.checkPipesConnections((IBlockAccess)world, tile1, i - 1, j, k)) {
            this.func_71905_a(0.0f, 0.25f, 0.25f, 0.75f, 0.75f, 0.75f);
            super.func_71871_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
        }
        if (Utils.checkPipesConnections((IBlockAccess)world, tile1, i + 1, j, k)) {
            this.func_71905_a(0.25f, 0.25f, 0.25f, 1.0f, 0.75f, 0.75f);
            super.func_71871_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
        }
        if (Utils.checkPipesConnections((IBlockAccess)world, tile1, i, j - 1, k)) {
            this.func_71905_a(0.25f, 0.0f, 0.25f, 0.75f, 0.75f, 0.75f);
            super.func_71871_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
        }
        if (Utils.checkPipesConnections((IBlockAccess)world, tile1, i, j + 1, k)) {
            this.func_71905_a(0.25f, 0.25f, 0.25f, 0.75f, 1.0f, 0.75f);
            super.func_71871_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
        }
        if (Utils.checkPipesConnections((IBlockAccess)world, tile1, i, j, k - 1)) {
            this.func_71905_a(0.25f, 0.25f, 0.0f, 0.75f, 0.75f, 0.75f);
            super.func_71871_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
        }
        if (Utils.checkPipesConnections((IBlockAccess)world, tile1, i, j, k + 1)) {
            this.func_71905_a(0.25f, 0.25f, 0.25f, 0.75f, 0.75f, 1.0f);
            super.func_71871_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
        }
        if (tileG != null) {
            float facadeThickness = 0.0625f;
            if (tileG.hasFacade(ForgeDirection.EAST)) {
                this.func_71905_a(1.0f - facadeThickness, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                super.func_71871_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
            if (tileG.hasFacade(ForgeDirection.WEST)) {
                this.func_71905_a(0.0f, 0.0f, 0.0f, facadeThickness, 1.0f, 1.0f);
                super.func_71871_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
            if (tileG.hasFacade(ForgeDirection.UP)) {
                this.func_71905_a(0.0f, 1.0f - facadeThickness, 0.0f, 1.0f, 1.0f, 1.0f);
                super.func_71871_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
            if (tileG.hasFacade(ForgeDirection.DOWN)) {
                this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, facadeThickness, 1.0f);
                super.func_71871_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
            if (tileG.hasFacade(ForgeDirection.SOUTH)) {
                this.func_71905_a(0.0f, 0.0f, 1.0f - facadeThickness, 1.0f, 1.0f, 1.0f);
                super.func_71871_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
            if (tileG.hasFacade(ForgeDirection.NORTH)) {
                this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, facadeThickness);
                super.func_71871_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
        }
        this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public AxisAlignedBB func_71911_a_(World world, int i, int j, int k) {
        float xMin = 0.25f;
        float xMax = 0.75f;
        float yMin = 0.25f;
        float yMax = 0.75f;
        float zMin = 0.25f;
        float zMax = 0.75f;
        TileEntity tile1 = world.func_72796_p(i, j, k);
        TileGenericPipe tileG = (TileGenericPipe)tile1;
        if (tileG != null) {
            if (Utils.checkPipesConnections((IBlockAccess)world, tile1, i - 1, j, k) || tileG.hasFacade(ForgeDirection.WEST)) {
                xMin = 0.0f;
            }
            if (Utils.checkPipesConnections((IBlockAccess)world, tile1, i + 1, j, k) || tileG.hasFacade(ForgeDirection.EAST)) {
                xMax = 1.0f;
            }
            if (Utils.checkPipesConnections((IBlockAccess)world, tile1, i, j - 1, k) || tileG.hasFacade(ForgeDirection.DOWN)) {
                yMin = 0.0f;
            }
            if (Utils.checkPipesConnections((IBlockAccess)world, tile1, i, j + 1, k) || tileG.hasFacade(ForgeDirection.UP)) {
                yMax = 1.0f;
            }
            if (Utils.checkPipesConnections((IBlockAccess)world, tile1, i, j, k - 1) || tileG.hasFacade(ForgeDirection.NORTH)) {
                zMin = 0.0f;
            }
            if (Utils.checkPipesConnections((IBlockAccess)world, tile1, i, j, k + 1) || tileG.hasFacade(ForgeDirection.SOUTH)) {
                zMax = 1.0f;
            }
            if (tileG.hasFacade(ForgeDirection.EAST) || tileG.hasFacade(ForgeDirection.WEST)) {
                yMin = 0.0f;
                yMax = 1.0f;
                zMin = 0.0f;
                zMax = 1.0f;
            }
            if (tileG.hasFacade(ForgeDirection.UP) || tileG.hasFacade(ForgeDirection.DOWN)) {
                xMin = 0.0f;
                xMax = 1.0f;
                zMin = 0.0f;
                zMax = 1.0f;
            }
            if (tileG.hasFacade(ForgeDirection.SOUTH) || tileG.hasFacade(ForgeDirection.NORTH)) {
                xMin = 0.0f;
                xMax = 1.0f;
                yMin = 0.0f;
                yMax = 1.0f;
            }
        }
        return AxisAlignedBB.func_72330_a((double)((double)i + (double)xMin), (double)((double)j + (double)yMin), (double)((double)k + (double)zMin), (double)((double)i + (double)xMax), (double)((double)j + (double)yMax), (double)((double)k + (double)zMax));
    }

    public MovingObjectPosition func_71878_a(World world, int x, int y, int z, Vec3 origin, Vec3 direction) {
        RaytraceResult raytraceResult = this.doRayTrace(world, x, y, z, origin, direction);
        if (raytraceResult == null) {
            return null;
        }
        return raytraceResult.movingObjectPosition;
    }

    public RaytraceResult doRayTrace(World world, int x, int y, int z, EntityPlayer entityPlayer) {
        double pitch = Math.toRadians(entityPlayer.field_70125_A);
        double yaw = Math.toRadians(entityPlayer.field_70177_z);
        double dirX = -Math.sin(yaw) * Math.cos(pitch);
        double dirY = -Math.sin(pitch);
        double dirZ = Math.cos(yaw) * Math.cos(pitch);
        double reachDistance = 5.0;
        if (entityPlayer instanceof EntityPlayerMP) {
            reachDistance = ((EntityPlayerMP)entityPlayer).field_71134_c.getBlockReachDistance();
        }
        Vec3 origin = Vec3.field_82592_a.func_72345_a(entityPlayer.field_70165_t, entityPlayer.field_70163_u + 1.62 - (double)entityPlayer.field_70129_M, entityPlayer.field_70161_v);
        Vec3 direction = origin.func_72441_c(dirX * reachDistance, dirY * reachDistance, dirZ * reachDistance);
        return this.doRayTrace(world, x, y, z, origin, direction);
    }

    public RaytraceResult doRayTrace(World world, int x, int y, int z, Vec3 origin, Vec3 direction) {
        float xMin = 0.25f;
        float xMax = 0.75f;
        float yMin = 0.25f;
        float yMax = 0.75f;
        float zMin = 0.25f;
        float zMax = 0.75f;
        TileEntity pipeTileEntity = world.func_72796_p(x, y, z);
        Pipe pipe = BlockGenericPipe.getPipe((IBlockAccess)world, x, y, z);
        if (pipeTileEntity == null || !BlockGenericPipe.isValid(pipe)) {
            return null;
        }
        MovingObjectPosition[] hits = new MovingObjectPosition[]{null, null, null, null, null, null, null, null, null};
        boolean needAxisCheck = false;
        boolean needCenterCheck = true;
        if (Utils.checkPipesConnections((IBlockAccess)world, pipeTileEntity, x - 1, y, z)) {
            xMin = 0.0f;
            needAxisCheck = true;
        }
        if (Utils.checkPipesConnections((IBlockAccess)world, pipeTileEntity, x + 1, y, z)) {
            xMax = 1.0f;
            needAxisCheck = true;
        }
        if (needAxisCheck) {
            this.func_71905_a(xMin, yMin, zMin, xMax, yMax, zMax);
            hits[0] = super.func_71878_a(world, x, y, z, origin, direction);
            xMin = 0.25f;
            xMax = 0.75f;
            needAxisCheck = false;
            needCenterCheck = false;
        }
        if (Utils.checkPipesConnections((IBlockAccess)world, pipeTileEntity, x, y - 1, z)) {
            yMin = 0.0f;
            needAxisCheck = true;
        }
        if (Utils.checkPipesConnections((IBlockAccess)world, pipeTileEntity, x, y + 1, z)) {
            yMax = 1.0f;
            needAxisCheck = true;
        }
        if (needAxisCheck) {
            this.func_71905_a(xMin, yMin, zMin, xMax, yMax, zMax);
            hits[1] = super.func_71878_a(world, x, y, z, origin, direction);
            yMin = 0.25f;
            yMax = 0.75f;
            needAxisCheck = false;
            needCenterCheck = false;
        }
        if (Utils.checkPipesConnections((IBlockAccess)world, pipeTileEntity, x, y, z - 1)) {
            zMin = 0.0f;
            needAxisCheck = true;
        }
        if (Utils.checkPipesConnections((IBlockAccess)world, pipeTileEntity, x, y, z + 1)) {
            zMax = 1.0f;
            needAxisCheck = true;
        }
        if (needAxisCheck) {
            this.func_71905_a(xMin, yMin, zMin, xMax, yMax, zMax);
            hits[2] = super.func_71878_a(world, x, y, z, origin, direction);
            zMin = 0.25f;
            zMax = 0.75f;
            needAxisCheck = false;
            needCenterCheck = false;
        }
        if (needCenterCheck) {
            this.func_71905_a(xMin, yMin, zMin, xMax, yMax, zMax);
            hits[0] = super.func_71878_a(world, x, y, z, origin, direction);
        }
        if (pipe.hasGate()) {
            for (int side = 0; side < 6; ++side) {
                this.setBlockBoundsToGate(ForgeDirection.VALID_DIRECTIONS[side]);
                hits[3 + side] = super.func_71878_a(world, x, y, z, origin, direction);
            }
        }
        double minLengthSquared = Double.POSITIVE_INFINITY;
        int minIndex = -1;
        for (int i = 0; i < hits.length; ++i) {
            double lengthSquared;
            MovingObjectPosition hit = hits[i];
            if (hit == null || !((lengthSquared = hit.field_72307_f.func_72436_e(origin)) < minLengthSquared)) continue;
            minLengthSquared = lengthSquared;
            minIndex = i;
        }
        this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        if (minIndex == -1) {
            return null;
        }
        Part hitPart = minIndex < 3 ? Part.Pipe : Part.Gate;
        return new RaytraceResult(hitPart, hits[minIndex]);
    }

    private void setBlockBoundsToGate(ForgeDirection dir) {
        float min = 0.3f;
        float max = 0.7f;
        switch (dir) {
            case DOWN: {
                this.func_71905_a(min, 0.15f, min, max, 0.25f, max);
                break;
            }
            case UP: {
                this.func_71905_a(min, 0.75f, min, max, 0.85f, max);
                break;
            }
            case NORTH: {
                this.func_71905_a(min, min, 0.15f, max, max, 0.25f);
                break;
            }
            case SOUTH: {
                this.func_71905_a(min, min, 0.75f, max, max, 0.85f);
                break;
            }
            case WEST: {
                this.func_71905_a(0.15f, min, min, 0.25f, max, max);
                break;
            }
            default: {
                this.func_71905_a(0.75f, min, min, 0.85f, max, max);
            }
        }
    }

    public static void removePipe(Pipe pipe) {
        World world;
        if (pipe == null) {
            return;
        }
        if (BlockGenericPipe.isValid(pipe)) {
            pipe.onBlockRemoval();
        }
        if ((world = pipe.worldObj) == null) {
            return;
        }
        int i = pipe.xCoord;
        int j = pipe.yCoord;
        int k = pipe.zCoord;
        if (lastRemovedDate != world.func_72820_D()) {
            lastRemovedDate = world.func_72820_D();
            pipeRemoved.clear();
        }
        pipeRemoved.put(new BlockIndex(i, j, k), pipe);
        world.func_72932_q(i, j, k);
    }

    public void func_71852_a(World world, int x, int y, int z, int par5, int par6) {
        Utils.preDestroyBlock(world, x, y, z);
        BlockGenericPipe.removePipe(BlockGenericPipe.getPipe((IBlockAccess)world, x, y, z));
        super.func_71852_a(world, x, y, z, par5, par6);
    }

    public ArrayList<ItemStack> getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
        if (CoreProxy.proxy.isRenderWorld(world)) {
            return null;
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        int count = this.quantityDropped(metadata, fortune, world.field_73012_v);
        for (int i = 0; i < count; ++i) {
            Pipe pipe = BlockGenericPipe.getPipe((IBlockAccess)world, x, y, z);
            if (pipe == null) {
                pipe = pipeRemoved.get(new BlockIndex(x, y, z));
            }
            if (pipe == null || pipe.itemID <= 0) continue;
            pipe.dropContents();
            list.add(new ItemStack(pipe.itemID, 1, this.func_71899_b(metadata)));
        }
        return list;
    }

    public TileEntity func_72274_a(World var1) {
        return new TileGenericPipe();
    }

    public void func_71914_a(World world, int i, int j, int k, int l, float f, int dmg) {
        if (CoreProxy.proxy.isRenderWorld(world)) {
            return;
        }
        int i1 = this.func_71925_a(world.field_73012_v);
        for (int j1 = 0; j1 < i1; ++j1) {
            int k1;
            if (world.field_73012_v.nextFloat() > f) continue;
            Pipe pipe = BlockGenericPipe.getPipe((IBlockAccess)world, i, j, k);
            if (pipe == null) {
                pipe = pipeRemoved.get(new BlockIndex(i, j, k));
            }
            if (pipe == null || (k1 = pipe.itemID) <= 0) continue;
            pipe.dropContents();
            this.func_71929_a(world, i, j, k, new ItemStack(k1, 1, this.func_71899_b(l)));
        }
    }

    public int func_71885_a(int meta, Random rand, int dmg) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71922_a(World world, int i, int j, int k) {
        Pipe pipe = BlockGenericPipe.getPipe((IBlockAccess)world, i, j, k);
        if (pipe == null) {
            return 0;
        }
        return pipe.itemID;
    }

    public void func_71863_a(World world, int x, int y, int z, int l) {
        super.func_71863_a(world, x, y, z, l);
        Pipe pipe = BlockGenericPipe.getPipe((IBlockAccess)world, x, y, z);
        if (BlockGenericPipe.isValid(pipe)) {
            pipe.container.scheduleNeighborChange();
        }
    }

    public int func_85104_a(World world, int x, int y, int z, int side, float par6, float par7, float par8, int meta) {
        super.func_85104_a(world, x, y, z, side, par6, par7, par8, meta);
        Pipe pipe = BlockGenericPipe.getPipe((IBlockAccess)world, x, y, z);
        if (BlockGenericPipe.isValid(pipe)) {
            pipe.onBlockPlaced();
        }
        return meta;
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLiving placer, ItemStack stack) {
        super.func_71860_a(world, x, y, z, placer, stack);
        Pipe pipe = BlockGenericPipe.getPipe((IBlockAccess)world, x, y, z);
        if (BlockGenericPipe.isValid(pipe)) {
            pipe.onBlockPlacedBy(placer);
        }
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer entityplayer, int par6, float xOffset, float yOffset, float zOffset) {
        super.func_71903_a(world, x, y, z, entityplayer, par6, xOffset, yOffset, zOffset);
        world.func_72898_h(x, y, z, BuildCraftTransport.genericPipeBlock.field_71990_ca);
        Pipe pipe = BlockGenericPipe.getPipe((IBlockAccess)world, x, y, z);
        if (BlockGenericPipe.isValid(pipe)) {
            RaytraceResult rayTraceResult;
            if (entityplayer.func_70093_af() && (entityplayer.func_71045_bC() == null || !(entityplayer.func_71045_bC().func_77973_b() instanceof IToolWrench))) {
                if (pipe.hasGate() || pipe.isWired()) {
                    return this.stripEquipment(pipe);
                }
            } else if (entityplayer.func_71045_bC() != null) {
                if (entityplayer.func_71045_bC().field_77993_c == Item.field_77792_au.field_77779_bT) {
                    return false;
                }
                if (entityplayer.func_71045_bC().func_77973_b() instanceof ItemPipe) {
                    return false;
                }
                if (entityplayer.func_71045_bC().func_77973_b() instanceof IToolWrench) {
                    return pipe.blockActivated(world, x, y, z, entityplayer);
                }
                if (entityplayer.func_71045_bC().func_77973_b() == BuildCraftTransport.redPipeWire) {
                    if (!pipe.wireSet[IPipe.WireColor.Red.ordinal()]) {
                        pipe.wireSet[IPipe.WireColor.Red.ordinal()] = true;
                        if (!entityplayer.field_71075_bZ.field_75098_d) {
                            entityplayer.func_71045_bC().func_77979_a(1);
                        }
                        pipe.signalStrength[IPipe.WireColor.Red.ordinal()] = 0;
                        pipe.container.scheduleNeighborChange();
                        return true;
                    }
                } else if (entityplayer.func_71045_bC().func_77973_b() == BuildCraftTransport.bluePipeWire) {
                    if (!pipe.wireSet[IPipe.WireColor.Blue.ordinal()]) {
                        pipe.wireSet[IPipe.WireColor.Blue.ordinal()] = true;
                        if (!entityplayer.field_71075_bZ.field_75098_d) {
                            entityplayer.func_71045_bC().func_77979_a(1);
                        }
                        pipe.signalStrength[IPipe.WireColor.Blue.ordinal()] = 0;
                        pipe.container.scheduleNeighborChange();
                        return true;
                    }
                } else if (entityplayer.func_71045_bC().func_77973_b() == BuildCraftTransport.greenPipeWire) {
                    if (!pipe.wireSet[IPipe.WireColor.Green.ordinal()]) {
                        pipe.wireSet[IPipe.WireColor.Green.ordinal()] = true;
                        if (!entityplayer.field_71075_bZ.field_75098_d) {
                            entityplayer.func_71045_bC().func_77979_a(1);
                        }
                        pipe.signalStrength[IPipe.WireColor.Green.ordinal()] = 0;
                        pipe.container.scheduleNeighborChange();
                        return true;
                    }
                } else if (entityplayer.func_71045_bC().func_77973_b() == BuildCraftTransport.yellowPipeWire) {
                    if (!pipe.wireSet[IPipe.WireColor.Yellow.ordinal()]) {
                        pipe.wireSet[IPipe.WireColor.Yellow.ordinal()] = true;
                        if (!entityplayer.field_71075_bZ.field_75098_d) {
                            entityplayer.func_71045_bC().func_77979_a(1);
                        }
                        pipe.signalStrength[IPipe.WireColor.Yellow.ordinal()] = 0;
                        pipe.container.scheduleNeighborChange();
                        return true;
                    }
                } else if (!(entityplayer.func_71045_bC().field_77993_c != BuildCraftTransport.pipeGate.field_77779_bT && entityplayer.func_71045_bC().field_77993_c != BuildCraftTransport.pipeGateAutarchic.field_77779_bT || pipe.hasInterface())) {
                    pipe.gate = new GateVanilla(pipe, entityplayer.func_71045_bC());
                    if (!entityplayer.field_71075_bZ.field_75098_d) {
                        entityplayer.func_71045_bC().func_77979_a(1);
                    }
                    pipe.container.scheduleRenderUpdate();
                    return true;
                }
            }
            boolean openGateGui = false;
            if (pipe.hasGate() && (rayTraceResult = this.doRayTrace(world, x, y, z, entityplayer)) != null && rayTraceResult.hitPart == Part.Gate) {
                openGateGui = true;
            }
            if (openGateGui) {
                pipe.gate.openGui(entityplayer);
                return true;
            }
            return pipe.blockActivated(world, x, y, z, entityplayer);
        }
        return false;
    }

    private boolean stripEquipment(Pipe pipe) {
        for (IPipe.WireColor color : IPipe.WireColor.values()) {
            if (!pipe.wireSet[color.reverse().ordinal()]) continue;
            if (!CoreProxy.proxy.isRenderWorld(pipe.worldObj)) {
                this.dropWire(color.reverse(), pipe.worldObj, pipe.xCoord, pipe.yCoord, pipe.zCoord);
            }
            pipe.wireSet[color.reverse().ordinal()] = false;
            pipe.container.scheduleRenderUpdate();
            return true;
        }
        if (pipe.hasGate()) {
            if (!CoreProxy.proxy.isRenderWorld(pipe.worldObj)) {
                pipe.gate.dropGate(pipe.worldObj, pipe.xCoord, pipe.yCoord, pipe.zCoord);
            }
            pipe.resetGate();
            return true;
        }
        return false;
    }

    private void dropWire(IPipe.WireColor color, World world, int i, int j, int k) {
        Item wireItem;
        switch (color) {
            case Red: {
                wireItem = BuildCraftTransport.redPipeWire;
                break;
            }
            case Blue: {
                wireItem = BuildCraftTransport.bluePipeWire;
                break;
            }
            case Green: {
                wireItem = BuildCraftTransport.greenPipeWire;
                break;
            }
            default: {
                wireItem = BuildCraftTransport.yellowPipeWire;
            }
        }
        Utils.dropItems(world, new ItemStack(wireItem), i, j, k);
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71895_b(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        TileEntity tile = iblockaccess.func_72796_p(i, j, k);
        if (!(tile instanceof IPipeRenderState)) {
            return null;
        }
        return ((IPipeRenderState)tile).getRenderState().currentTexture;
    }

    public void func_71869_a(World world, int i, int j, int k, Entity entity) {
        super.func_71869_a(world, i, j, k, entity);
        Pipe pipe = BlockGenericPipe.getPipe((IBlockAccess)world, i, j, k);
        if (BlockGenericPipe.isValid(pipe)) {
            pipe.onEntityCollidedWithBlock(entity);
        }
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        Pipe pipe = BlockGenericPipe.getPipe(world, x, y, z);
        if (BlockGenericPipe.isValid(pipe)) {
            return pipe.canConnectRedstone();
        }
        return false;
    }

    public int func_71855_c(IBlockAccess iblockaccess, int x, int y, int z, int l) {
        Pipe pipe = BlockGenericPipe.getPipe(iblockaccess, x, y, z);
        if (BlockGenericPipe.isValid(pipe)) {
            return pipe.isPoweringTo(l);
        }
        return 0;
    }

    public boolean func_71853_i() {
        return true;
    }

    public int func_71865_a(IBlockAccess world, int i, int j, int k, int l) {
        Pipe pipe = BlockGenericPipe.getPipe(world, i, j, k);
        if (BlockGenericPipe.isValid(pipe)) {
            return pipe.isIndirectlyPoweringTo(l);
        }
        return 0;
    }

    public void func_71862_a(World world, int i, int j, int k, Random random) {
        Pipe pipe = BlockGenericPipe.getPipe((IBlockAccess)world, i, j, k);
        if (BlockGenericPipe.isValid(pipe)) {
            pipe.randomDisplayTick(random);
        }
    }

    public static ItemPipe registerPipe(int key, Class<? extends Pipe> clas) {
        ItemPipe item = new ItemPipe(key);
        item.func_77655_b("buildcraftPipe." + clas.getSimpleName().toLowerCase(Locale.ENGLISH));
        GameRegistry.registerItem((Item)item, (String)item.func_77658_a());
        pipes.put(item.field_77779_bT, clas);
        Pipe dummyPipe = BlockGenericPipe.createPipe(item.field_77779_bT);
        if (dummyPipe != null) {
            item.setPipeIconIndex(dummyPipe.getIconIndexForItem());
            TransportProxy.proxy.setIconProviderFromPipe(item, dummyPipe);
        }
        return item;
    }

    public static boolean isPipeRegistered(int key) {
        return pipes.containsKey(key);
    }

    public static Pipe createPipe(int key) {
        try {
            Class<? extends Pipe> pipe = pipes.get(key);
            if (pipe != null) {
                return pipe.getConstructor(Integer.TYPE).newInstance(key);
            }
            BuildCraftCore.bcLog.warning("Detected pipe with unknown key (" + key + "). Did you remove a buildcraft addon?");
        }
        catch (Throwable t) {
            BuildCraftCore.bcLog.warning("Failed to create pipe with (" + key + "). No valid constructor found. Possibly a item ID conflit.");
        }
        return null;
    }

    public static boolean placePipe(Pipe pipe, World world, int i, int j, int k, int blockId, int meta) {
        if (world.field_72995_K) {
            return true;
        }
        boolean placed = world.func_72832_d(i, j, k, blockId, meta, 1);
        if (placed) {
            TileGenericPipe tile = (TileGenericPipe)world.func_72796_p(i, j, k);
            tile.initialize(pipe);
        }
        return placed;
    }

    public static Pipe getPipe(IBlockAccess blockAccess, int i, int j, int k) {
        TileEntity tile = blockAccess.func_72796_p(i, j, k);
        if (!(tile instanceof TileGenericPipe) || tile.func_70320_p()) {
            return null;
        }
        return ((TileGenericPipe)tile).pipe;
    }

    public static boolean isFullyDefined(Pipe pipe) {
        return pipe != null && pipe.transport != null && pipe.logic != null;
    }

    public static boolean isValid(Pipe pipe) {
        return BlockGenericPipe.isFullyDefined(pipe);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        if (!this.skippedFirstIconRegister) {
            this.skippedFirstIconRegister = true;
            return;
        }
        BuildCraftTransport.instance.gateIconProvider.registerIcons(iconRegister);
        BuildCraftTransport.instance.wireIconProvider.registerIcons(iconRegister);
        for (int i : pipes.keySet()) {
            Pipe dummyPipe = BlockGenericPipe.createPipe(i);
            if (dummyPipe == null) continue;
            dummyPipe.getIconProvider().registerIcons(iconRegister);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int par1, int par2) {
        return BuildCraftTransport.instance.pipeIconProvider.getIcon(33);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addBlockHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        int x = target.field_72311_b;
        int y = target.field_72312_c;
        int z = target.field_72309_d;
        Pipe pipe = BlockGenericPipe.getPipe((IBlockAccess)worldObj, x, y, z);
        if (pipe == null) {
            return false;
        }
        Icon icon = pipe.getIconProvider().getIcon(pipe.getIconIndexForItem());
        int sideHit = target.field_72310_e;
        BlockGenericPipe block = BuildCraftTransport.genericPipeBlock;
        float b = 0.1f;
        double px = (double)x + rand.nextDouble() * (block.func_83007_w() - block.func_83009_v() - (double)(b * 2.0f)) + (double)b + block.func_83009_v();
        double py = (double)y + rand.nextDouble() * (block.func_83010_y() - block.func_83008_x() - (double)(b * 2.0f)) + (double)b + block.func_83008_x();
        double pz = (double)z + rand.nextDouble() * (block.func_83006_A() - block.func_83005_z() - (double)(b * 2.0f)) + (double)b + block.func_83005_z();
        if (sideHit == 0) {
            py = (double)y + block.func_83008_x() - (double)b;
        }
        if (sideHit == 1) {
            py = (double)y + block.func_83010_y() + (double)b;
        }
        if (sideHit == 2) {
            pz = (double)z + block.func_83005_z() - (double)b;
        }
        if (sideHit == 3) {
            pz = (double)z + block.func_83006_A() + (double)b;
        }
        if (sideHit == 4) {
            px = (double)x + block.func_83009_v() - (double)b;
        }
        if (sideHit == 5) {
            px = (double)x + block.func_83007_w() + (double)b;
        }
        EntityDiggingFX fx = new EntityDiggingFX(worldObj, px, py, pz, 0.0, 0.0, 0.0, (Block)block, sideHit, worldObj.func_72805_g(x, y, z), Minecraft.func_71410_x().field_71446_o);
        fx.func_94052_a(Minecraft.func_71410_x().field_71446_o, icon);
        effectRenderer.func_78873_a(fx.func_70596_a(x, y, z).func_70543_e(0.2f).func_70541_f(0.6f));
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addBlockDestroyEffects(World worldObj, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        Pipe pipe = BlockGenericPipe.getPipe((IBlockAccess)worldObj, x, y, z);
        if (pipe == null) {
            return false;
        }
        Icon icon = pipe.getIconProvider().getIcon(pipe.getIconIndexForItem());
        int its = 4;
        for (int i = 0; i < its; ++i) {
            for (int j = 0; j < its; ++j) {
                for (int k = 0; k < its; ++k) {
                    double px = (double)x + ((double)i + 0.5) / (double)its;
                    double py = (double)y + ((double)j + 0.5) / (double)its;
                    double pz = (double)z + ((double)k + 0.5) / (double)its;
                    int random = rand.nextInt(6);
                    EntityDiggingFX fx = new EntityDiggingFX(worldObj, px, py, pz, px - (double)x - 0.5, py - (double)y - 0.5, pz - (double)z - 0.5, (Block)BuildCraftTransport.genericPipeBlock, random, meta, Minecraft.func_71410_x().field_71446_o);
                    fx.func_94052_a(Minecraft.func_71410_x().field_71446_o, icon);
                    effectRenderer.func_78873_a((EntityFX)fx.func_70596_a(x, y, z));
                }
            }
        }
        return true;
    }

    public int func_71920_b(IBlockAccess world, int x, int y, int z) {
        if (facadeRenderColor != -1) {
            return facadeRenderColor;
        }
        return super.func_71920_b(world, x, y, z);
    }

    static class RaytraceResult {
        public Part hitPart;
        public MovingObjectPosition movingObjectPosition;

        RaytraceResult(Part hitPart, MovingObjectPosition movingObjectPosition) {
            this.hitPart = hitPart;
            this.movingObjectPosition = movingObjectPosition;
        }
    }

    static enum Part {
        Pipe,
        Gate;

    }
}

