/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.BuildCraftCore;
import buildcraft.api.gates.IAction;
import buildcraft.api.gates.IActionReceptor;
import buildcraft.core.IMachine;
import buildcraft.core.TileBuffer;
import buildcraft.core.inventory.InvUtils;
import buildcraft.core.inventory.InventoryCopy;
import buildcraft.core.inventory.InventoryIterator;
import buildcraft.core.inventory.InventoryMapper;
import buildcraft.core.inventory.SimpleInventory;
import buildcraft.core.inventory.StackHelper;
import buildcraft.core.inventory.Transactor;
import buildcraft.core.inventory.filters.CraftingFilter;
import buildcraft.core.network.PacketSlotChange;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.triggers.ActionMachineControl;
import buildcraft.core.utils.CraftingHelper;
import buildcraft.core.utils.Utils;
import buildcraft.silicon.ILaserTarget;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class TileAdvancedCraftingTable
extends TileEntity
implements IInventory,
ILaserTarget,
IMachine,
IActionReceptor,
ISidedInventory {
    public InventoryCraftResult craftResult;
    private InternalInventoryCrafting internalInventoryCrafting;
    private static final int[] SLOTS = Utils.createSlotArray(0, 24);
    private static final EnumSet<ForgeDirection> SEARCH_SIDES = EnumSet.of(ForgeDirection.DOWN, ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST);
    private static final float REQUIRED_POWER = 500.0f;
    private final SimpleInventory craftingSlots;
    private final SimpleInventory storageSlots;
    private final InventoryMapper invInput;
    private final InventoryMapper invOutput;
    private SlotCrafting craftSlot;
    private float storedEnergy;
    private float[] recentEnergy = new float[20];
    private boolean craftable;
    private boolean justCrafted;
    private int tick;
    private int recentEnergyAverage;
    private InternalPlayer internalPlayer;
    private IRecipe currentRecipe;
    private ActionMachineControl.Mode lastMode = ActionMachineControl.Mode.Unknown;
    private TileBuffer[] cache;

    public TileAdvancedCraftingTable() {
        this.craftingSlots = new SimpleInventory(9, "CraftingSlots", 1);
        this.storageSlots = new SimpleInventory(24, "StorageSlots", 64);
        this.storageSlots.addListener(this);
        this.invInput = new InventoryMapper(this.storageSlots, 0, 15);
        this.invOutput = new InventoryMapper(this.storageSlots, 15, 9);
        this.craftResult = new InventoryCraftResult();
    }

    public int func_70302_i_() {
        return this.storageSlots.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.storageSlots.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return this.storageSlots.func_70298_a(slot, amount);
    }

    public ItemStack func_70304_b(int slot) {
        return this.storageSlots.func_70304_b(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.storageSlots.func_70299_a(slot, stack);
    }

    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        this.storageSlots.writeToNBT(data, "StorageSlots");
        this.craftingSlots.writeToNBT(data);
        data.func_74776_a("StoredEnergy", this.storedEnergy);
    }

    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.storageSlots.readFromNBT(data, "StorageSlots");
        this.craftingSlots.readFromNBT(data);
        this.storedEnergy = data.func_74760_g("StoredEnergy");
    }

    public String func_70303_b() {
        return "AdvancedWorkbench";
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.craftable = this.craftResult.func_70301_a(0) != null;
    }

    public int func_70297_j_() {
        return this.storageSlots.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) == this;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int getRecentEnergyAverage() {
        return this.recentEnergyAverage;
    }

    public float getStoredEnergy() {
        return this.storedEnergy;
    }

    public float getRequiredEnergy() {
        return this.craftResult.func_70301_a(0) != null ? 500.0f : 0.0f;
    }

    public int getProgressScaled(int i) {
        return (int)(this.storedEnergy * (float)i / 500.0f);
    }

    public void func_70313_j() {
        super.func_70313_j();
        this.cache = null;
    }

    public void func_70316_g() {
        if (this.internalPlayer == null) {
            this.internalInventoryCrafting = new InternalInventoryCrafting();
            this.internalPlayer = new InternalPlayer();
            this.craftSlot = new SlotCrafting((EntityPlayer)this.internalPlayer, (IInventory)this.internalInventoryCrafting, (IInventory)this.craftResult, 0, 0, 0);
            this.updateCraftingResults();
        }
        if (!CoreProxy.proxy.isSimulating(this.field_70331_k)) {
            return;
        }
        if (this.lastMode == ActionMachineControl.Mode.Off) {
            return;
        }
        this.updateCraftingResults();
        this.findIngredients();
        this.justCrafted = false;
        ++this.tick;
        this.tick %= this.recentEnergy.length;
        this.recentEnergy[this.tick] = 0.0f;
        if (this.craftResult.func_70301_a(0) != null) {
            this.internalInventoryCrafting.tempStacks = new InventoryCopy(this.storageSlots).getItemStacks();
            this.internalInventoryCrafting.hitCount = new int[this.internalInventoryCrafting.tempStacks.length];
            if (this.hasIngredients() && InvUtils.isRoomForStack(this.craftResult.func_70301_a(0), ForgeDirection.UP, this.invOutput)) {
                if (this.storedEnergy >= this.getRequiredEnergy()) {
                    this.craftItem();
                    this.justCrafted = true;
                }
            } else {
                this.craftable = false;
                this.internalInventoryCrafting.tempStacks = null;
                this.internalInventoryCrafting.hitCount = null;
                this.storedEnergy = 0.0f;
            }
        } else {
            this.craftable = false;
            this.internalInventoryCrafting.tempStacks = null;
            this.internalInventoryCrafting.hitCount = null;
            this.storedEnergy = 0.0f;
        }
    }

    private boolean hasIngredients() {
        ItemStack[] tempStorage = this.internalInventoryCrafting.tempStacks;
        for (int j = 0; j < this.craftingSlots.func_70302_i_(); ++j) {
            if (this.craftingSlots.func_70301_a(j) == null) {
                this.internalInventoryCrafting.bindings[j] = -1;
                continue;
            }
            boolean matchedStorage = false;
            for (int i = 0; i < tempStorage.length; ++i) {
                if (tempStorage[i] == null || !StackHelper.instance().isCraftingEquivalent(this.craftingSlots.func_70301_a(j), tempStorage[i], true) || this.internalInventoryCrafting.hitCount[i] >= tempStorage[i].field_77994_a || this.internalInventoryCrafting.hitCount[i] >= tempStorage[i].func_77976_d()) continue;
                this.internalInventoryCrafting.bindings[j] = i;
                int n = i;
                this.internalInventoryCrafting.hitCount[n] = this.internalInventoryCrafting.hitCount[n] + 1;
                matchedStorage = true;
                break;
            }
            if (matchedStorage) continue;
            return false;
        }
        return this.currentRecipe.func_77569_a((InventoryCrafting)this.internalInventoryCrafting, this.field_70331_k);
    }

    private void craftItem() {
        this.craftSlot.func_82870_a((EntityPlayer)this.internalPlayer, this.craftResult.func_70301_a(0));
        ItemStack[] tempStorage = this.internalInventoryCrafting.tempStacks;
        for (int i = 0; i < tempStorage.length; ++i) {
            if (tempStorage[i] != null && tempStorage[i].field_77994_a <= 0) {
                tempStorage[i] = null;
            }
            this.storageSlots.getItemStacks()[i] = tempStorage[i];
        }
        this.storedEnergy -= this.getRequiredEnergy();
        ArrayList outputs = Lists.newArrayList((Object[])new ItemStack[]{this.craftResult.func_70301_a(0).func_77946_l()});
        for (int i = 0; i < this.internalPlayer.field_71071_by.field_70462_a.length; ++i) {
            if (this.internalPlayer.field_71071_by.field_70462_a[i] == null) continue;
            outputs.add(this.internalPlayer.field_71071_by.field_70462_a[i]);
            this.internalPlayer.field_71071_by.field_70462_a[i] = null;
        }
        for (ItemStack output : outputs) {
            output.field_77994_a -= Transactor.getTransactorFor((Object)this.invOutput).add((ItemStack)output, (ForgeDirection)ForgeDirection.UP, (boolean)true).field_77994_a;
            if (output.field_77994_a > 0) {
                output.field_77994_a -= Utils.addToRandomInventory((ItemStack)output, (World)this.field_70331_k, (int)this.field_70329_l, (int)this.field_70330_m, (int)this.field_70327_n).field_77994_a;
            }
            if (output.field_77994_a <= 0) continue;
            Utils.dropItems(this.field_70331_k, output, this.field_70329_l, this.field_70330_m + 1, this.field_70327_n);
        }
    }

    private void findIngredients() {
        if (this.cache == null) {
            this.cache = TileBuffer.makeBuffer(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, false);
        }
        for (InventoryIterator.IInvSlot slot : InventoryIterator.getIterable(this.craftingSlots, ForgeDirection.UP)) {
            CraftingFilter filter;
            ItemStack ingred = slot.getStackInSlot();
            if (ingred == null || InvUtils.countItems((IInventory)this.invInput, ForgeDirection.UP, filter = new CraftingFilter(ingred)) >= InvUtils.countItems((IInventory)this.craftingSlots, ForgeDirection.UP, filter)) continue;
            for (ForgeDirection side : SEARCH_SIDES) {
                IInventory inv;
                ItemStack result;
                TileEntity tile = this.cache[side.ordinal()].getTile();
                if (!(tile instanceof IInventory) || (result = InvUtils.moveOneItem(inv = Utils.getInventory((IInventory)tile), side.getOpposite(), (IInventory)this.invInput, side, filter)) == null) continue;
                return;
            }
        }
    }

    public void updateCraftingMatrix(int slot, ItemStack stack) {
        this.craftingSlots.func_70299_a(slot, stack);
        this.updateCraftingResults();
        if (CoreProxy.proxy.isRenderWorld(this.field_70331_k)) {
            PacketSlotChange packet = new PacketSlotChange(70, this.field_70329_l, this.field_70330_m, this.field_70327_n, slot, stack);
            CoreProxy.proxy.sendToServer(packet.getPacket());
        }
    }

    private void updateCraftingResults() {
        if (this.internalInventoryCrafting == null) {
            return;
        }
        this.internalInventoryCrafting.recipeUpdate(true);
        if (this.currentRecipe == null || !this.currentRecipe.func_77569_a((InventoryCrafting)this.internalInventoryCrafting, this.field_70331_k)) {
            this.currentRecipe = CraftingHelper.findMatchingRecipe(this.internalInventoryCrafting, this.field_70331_k);
        }
        ItemStack resultStack = null;
        if (this.currentRecipe != null) {
            resultStack = this.currentRecipe.func_77572_b((InventoryCrafting)this.internalInventoryCrafting);
        }
        this.craftResult.func_70299_a(0, resultStack);
        this.internalInventoryCrafting.recipeUpdate(false);
        this.func_70296_d();
    }

    public IInventory getCraftingSlots() {
        return this.craftingSlots;
    }

    public IInventory getOutputSlot() {
        return this.craftResult;
    }

    @Override
    public boolean hasCurrentWork() {
        return this.craftable && !this.justCrafted && this.lastMode != ActionMachineControl.Mode.Off;
    }

    @Override
    public void receiveLaserEnergy(float energy) {
        this.storedEnergy += energy;
        int n = this.tick;
        this.recentEnergy[n] = this.recentEnergy[n] + energy;
    }

    @Override
    public boolean isLaserInvalid() {
        return this.func_70320_p();
    }

    @Override
    public int getXCoord() {
        return this.field_70329_l;
    }

    @Override
    public int getYCoord() {
        return this.field_70330_m;
    }

    @Override
    public int getZCoord() {
        return this.field_70327_n;
    }

    @Override
    public boolean isActive() {
        return this.hasCurrentWork();
    }

    @Override
    public boolean manageLiquids() {
        return false;
    }

    @Override
    public boolean manageSolids() {
        return false;
    }

    @Override
    public boolean allowAction(IAction action) {
        return action == BuildCraftCore.actionOn || action == BuildCraftCore.actionOff;
    }

    public void getGUINetworkData(int id, int data) {
        int currentStored = (int)((double)this.storedEnergy * 100.0);
        switch (id) {
            case 1: {
                currentStored = currentStored & 0xFFFF0000 | data & 0xFFFF;
                this.storedEnergy = (float)currentStored / 100.0f;
                break;
            }
            case 3: {
                currentStored = currentStored & 0xFFFF | (data & 0xFFFF) << 16;
                this.storedEnergy = (float)currentStored / 100.0f;
                break;
            }
            case 4: {
                this.recentEnergyAverage = this.recentEnergyAverage & 0xFFFF0000 | data & 0xFFFF;
                break;
            }
            case 5: {
                this.recentEnergyAverage = this.recentEnergyAverage & 0xFFFF | (data & 0xFFFF) << 16;
            }
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        int currentStored = (int)((double)this.storedEnergy * 100.0);
        int lRecentEnergy = 0;
        for (int i = 0; i < this.recentEnergy.length; ++i) {
            lRecentEnergy += (int)((double)this.recentEnergy[i] * 100.0 / (double)(this.recentEnergy.length - 1));
        }
        iCrafting.func_71112_a(container, 1, currentStored & 0xFFFF);
        iCrafting.func_71112_a(container, 3, currentStored >>> 16 & 0xFFFF);
        iCrafting.func_71112_a(container, 4, lRecentEnergy & 0xFFFF);
        iCrafting.func_71112_a(container, 5, lRecentEnergy >>> 16 & 0xFFFF);
    }

    public boolean func_94042_c() {
        return false;
    }

    public int[] func_94128_d(int side) {
        return SLOTS;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot >= 15;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot < 15;
    }

    @Override
    public void actionActivated(IAction action) {
        if (action == BuildCraftCore.actionOn) {
            this.lastMode = ActionMachineControl.Mode.On;
        } else if (action == BuildCraftCore.actionOff) {
            this.lastMode = ActionMachineControl.Mode.Off;
        }
    }

    private final class InternalPlayer
    extends EntityPlayer {
        public InternalPlayer() {
            super(TileAdvancedCraftingTable.this.field_70331_k);
            this.field_70165_t = TileAdvancedCraftingTable.this.field_70329_l;
            this.field_70163_u = TileAdvancedCraftingTable.this.field_70330_m + 1;
            this.field_70161_v = TileAdvancedCraftingTable.this.field_70327_n;
            this.field_71092_bJ = "[Buildcraft]";
        }

        public void func_70006_a(String var1) {
        }

        public boolean func_70003_b(int var1, String var2) {
            return false;
        }

        public ChunkCoordinates func_82114_b() {
            return null;
        }
    }

    private final class InternalInventoryCrafting
    extends InventoryCrafting {
        int[] bindings;
        ItemStack[] tempStacks;
        public int[] hitCount;
        private boolean useRecipeStack;

        private InternalInventoryCrafting() {
            super((Container)new InternalInventoryCraftingContainer(), 3, 3);
            this.bindings = new int[9];
        }

        public ItemStack func_70301_a(int slot) {
            if (slot >= 0 && slot < 9) {
                if (this.useRecipeStack || this.tempStacks == null) {
                    return TileAdvancedCraftingTable.this.craftingSlots.func_70301_a(slot);
                }
                if (this.bindings[slot] >= 0) {
                    return this.tempStacks[this.bindings[slot]];
                }
            }
            return null;
        }

        public void func_70299_a(int slot, ItemStack par2ItemStack) {
            if (this.tempStacks != null) {
                this.tempStacks[this.bindings[slot]] = par2ItemStack;
            }
        }

        public ItemStack func_70298_a(int slot, int amount) {
            if (this.tempStacks != null) {
                if (this.tempStacks[this.bindings[slot]].field_77994_a <= amount) {
                    ItemStack result = this.tempStacks[this.bindings[slot]];
                    this.tempStacks[this.bindings[slot]] = null;
                    return result;
                }
                ItemStack result = this.tempStacks[this.bindings[slot]].func_77979_a(amount);
                if (this.tempStacks[this.bindings[slot]].field_77994_a <= 0) {
                    this.tempStacks[this.bindings[slot]] = null;
                }
                return result;
            }
            return null;
        }

        public void recipeUpdate(boolean flag) {
            this.useRecipeStack = flag;
        }
    }

    private final class InternalInventoryCraftingContainer
    extends Container {
        private InternalInventoryCraftingContainer() {
        }

        public boolean func_75145_c(EntityPlayer var1) {
            return false;
        }
    }
}

