/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy.render;

import buildcraft.BuildCraftCore;
import buildcraft.core.DefaultProps;
import buildcraft.core.IInventoryRenderer;
import buildcraft.energy.Engine;
import buildcraft.energy.IEngineProvider;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderEngine
extends TileEntitySpecialRenderer
implements IInventoryRenderer {
    private ModelBase model = new ModelBase(){};
    private ModelRenderer box = new ModelRenderer(this.model, 0, 1);
    private ModelRenderer trunk;
    private ModelRenderer movingBox;
    private ModelRenderer chamber;
    private String baseTexture;
    private static final float[] angleMap = new float[6];

    public RenderEngine() {
        this.box.func_78789_a(-8.0f, -8.0f, -8.0f, 16, 4, 16);
        this.box.field_78800_c = 8.0f;
        this.box.field_78797_d = 8.0f;
        this.box.field_78798_e = 8.0f;
        this.trunk = new ModelRenderer(this.model, 1, 1);
        this.trunk.func_78789_a(-4.0f, -4.0f, -4.0f, 8, 12, 8);
        this.trunk.field_78800_c = 8.0f;
        this.trunk.field_78797_d = 8.0f;
        this.trunk.field_78798_e = 8.0f;
        this.movingBox = new ModelRenderer(this.model, 0, 1);
        this.movingBox.func_78789_a(-8.0f, -4.0f, -8.0f, 16, 4, 16);
        this.movingBox.field_78800_c = 8.0f;
        this.movingBox.field_78797_d = 8.0f;
        this.movingBox.field_78798_e = 8.0f;
        this.chamber = new ModelRenderer(this.model, 1, 1);
        this.chamber.func_78789_a(-5.0f, -4.0f, -5.0f, 10, 2, 10);
        this.chamber.field_78800_c = 8.0f;
        this.chamber.field_78797_d = 8.0f;
        this.chamber.field_78798_e = 8.0f;
    }

    public RenderEngine(String baseTexture) {
        this();
        this.baseTexture = baseTexture;
        this.func_76893_a(TileEntityRenderer.field_76963_a);
    }

    @Override
    public void inventoryRender(double x, double y, double z, float f, float f1) {
        this.render(Engine.EnergyStage.Blue, 0.25f, ForgeDirection.UP, this.baseTexture, x, y, z);
    }

    public void func_76894_a(TileEntity tileentity, double x, double y, double z, float f) {
        Engine engine = ((IEngineProvider)tileentity).getEngine();
        if (engine != null) {
            this.render(engine.getEnergyStage(), engine.progress, engine.orientation, engine.getTextureFile(), x, y, z);
        }
    }

    private void render(Engine.EnergyStage energy, float progress, ForgeDirection orientation, String baseTexture, double x, double y, double z) {
        if (BuildCraftCore.render == BuildCraftCore.RenderMode.NoDynamic) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        float step = (double)progress > 0.5 ? 7.99f - (progress - 0.5f) * 2.0f * 7.99f : progress * 2.0f * 7.99f;
        float translatefact = step / 16.0f;
        float[] angle = new float[]{0.0f, 0.0f, 0.0f};
        float[] translate = new float[]{orientation.offsetX, orientation.offsetY, orientation.offsetZ};
        switch (orientation) {
            case EAST: 
            case WEST: 
            case DOWN: {
                angle[2] = angleMap[orientation.ordinal()];
                break;
            }
            default: {
                angle[0] = angleMap[orientation.ordinal()];
            }
        }
        this.box.field_78795_f = angle[0];
        this.box.field_78796_g = angle[1];
        this.box.field_78808_h = angle[2];
        this.trunk.field_78795_f = angle[0];
        this.trunk.field_78796_g = angle[1];
        this.trunk.field_78808_h = angle[2];
        this.movingBox.field_78795_f = angle[0];
        this.movingBox.field_78796_g = angle[1];
        this.movingBox.field_78808_h = angle[2];
        this.chamber.field_78795_f = angle[0];
        this.chamber.field_78796_g = angle[1];
        this.chamber.field_78808_h = angle[2];
        float factor = 0.0625f;
        this.func_76897_a(baseTexture);
        this.box.func_78785_a(factor);
        GL11.glTranslatef((float)(translate[0] * translatefact), (float)(translate[1] * translatefact), (float)(translate[2] * translatefact));
        this.movingBox.func_78785_a(factor);
        GL11.glTranslatef((float)(-translate[0] * translatefact), (float)(-translate[1] * translatefact), (float)(-translate[2] * translatefact));
        this.func_76897_a(DefaultProps.TEXTURE_PATH_BLOCKS + "/chamber.png");
        float chamberf = 0.125f;
        int i = 0;
        while ((float)i <= step + 2.0f) {
            this.chamber.func_78785_a(factor);
            GL11.glTranslatef((float)(translate[0] * chamberf), (float)(translate[1] * chamberf), (float)(translate[2] * chamberf));
            i += 2;
        }
        i = 0;
        while ((float)i <= step + 2.0f) {
            GL11.glTranslatef((float)(-translate[0] * chamberf), (float)(-translate[1] * chamberf), (float)(-translate[2] * chamberf));
            i += 2;
        }
        String texture = "";
        switch (energy) {
            case Blue: {
                texture = DefaultProps.TEXTURE_PATH_BLOCKS + "/trunk_blue.png";
                break;
            }
            case Green: {
                texture = DefaultProps.TEXTURE_PATH_BLOCKS + "/trunk_green.png";
                break;
            }
            case Yellow: {
                texture = DefaultProps.TEXTURE_PATH_BLOCKS + "/trunk_yellow.png";
                break;
            }
            default: {
                texture = DefaultProps.TEXTURE_PATH_BLOCKS + "/trunk_red.png";
            }
        }
        this.func_76897_a(texture);
        this.trunk.func_78785_a(factor);
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    static {
        RenderEngine.angleMap[ForgeDirection.EAST.ordinal()] = -1.5707964f;
        RenderEngine.angleMap[ForgeDirection.WEST.ordinal()] = 1.5707964f;
        RenderEngine.angleMap[ForgeDirection.UP.ordinal()] = 0.0f;
        RenderEngine.angleMap[ForgeDirection.DOWN.ordinal()] = (float)Math.PI;
        RenderEngine.angleMap[ForgeDirection.SOUTH.ordinal()] = 1.5707964f;
        RenderEngine.angleMap[ForgeDirection.NORTH.ordinal()] = -1.5707964f;
    }
}

