/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy.gui;

import buildcraft.BuildCraftCore;
import buildcraft.core.CoreIconProvider;
import buildcraft.core.gui.BuildCraftContainer;
import buildcraft.core.gui.GuiBuildCraft;
import buildcraft.core.utils.StringUtils;
import buildcraft.energy.Engine;
import buildcraft.energy.TileEngine;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.IInventory;

public abstract class GuiEngine
extends GuiBuildCraft {
    public GuiEngine(BuildCraftContainer container, IInventory inventory) {
        super(container, inventory);
    }

    @Override
    protected void initLedgers(IInventory inventory) {
        super.initLedgers(inventory);
        this.ledgerManager.add(new EngineLedger(((TileEngine)this.tile).engine));
    }

    protected class EngineLedger
    extends GuiBuildCraft.Ledger {
        Engine engine;
        int headerColour;
        int subheaderColour;
        int textColour;

        public EngineLedger(Engine engine) {
            super(GuiEngine.this);
            this.headerColour = 14797103;
            this.subheaderColour = 11186104;
            this.textColour = 0;
            this.engine = engine;
            this.maxHeight = 94;
            this.overlayColor = 13921311;
        }

        @Override
        public void draw(int x, int y) {
            this.drawBackground(x, y);
            Minecraft.func_71410_x().field_71446_o.func_98187_b("/gui/items.png");
            this.drawIcon(BuildCraftCore.iconProvider.getIcon(CoreIconProvider.ENERGY), x + 3, y + 4);
            if (!this.isFullyOpened()) {
                return;
            }
            GuiEngine.this.field_73886_k.func_78261_a(StringUtils.localize("gui.energy"), x + 22, y + 8, this.headerColour);
            GuiEngine.this.field_73886_k.func_78261_a(StringUtils.localize("gui.currentOutput") + ":", x + 22, y + 20, this.subheaderColour);
            GuiEngine.this.field_73886_k.func_78276_b(String.format("%.1f MJ/t", Float.valueOf(this.engine.getCurrentOutput())), x + 22, y + 32, this.textColour);
            GuiEngine.this.field_73886_k.func_78261_a(StringUtils.localize("gui.stored") + ":", x + 22, y + 44, this.subheaderColour);
            GuiEngine.this.field_73886_k.func_78276_b(String.format("%.1f MJ", Float.valueOf(this.engine.getEnergyStored())), x + 22, y + 56, this.textColour);
            GuiEngine.this.field_73886_k.func_78261_a(StringUtils.localize("gui.heat") + ":", x + 22, y + 68, this.subheaderColour);
            GuiEngine.this.field_73886_k.func_78276_b(String.format("%.2f \u00b0C", (double)this.engine.getHeat() / 100.0 + 20.0), x + 22, y + 80, this.textColour);
        }

        @Override
        public String getTooltip() {
            return this.engine.getCurrentOutput() + " MJ/t";
        }
    }
}

