/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.render;

import buildcraft.core.render.RenderEntityBlock;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.opengl.GL11;

public class LiquidRenderer {
    private static Map<LiquidStack, int[]> flowingRenderCache = new HashMap<LiquidStack, int[]>();
    private static Map<LiquidStack, int[]> stillRenderCache = new HashMap<LiquidStack, int[]>();
    public static final int DISPLAY_STAGES = 100;
    private static final RenderEntityBlock.BlockInterface liquidBlock = new RenderEntityBlock.BlockInterface();

    public static Icon getLiquidTexture(LiquidStack liquid) {
        if (liquid == null || liquid.itemID <= 0) {
            return null;
        }
        LiquidStack canon = liquid.canonical();
        if (canon == null) {
            throw new LiquidCanonException(liquid);
        }
        Icon icon = canon.getRenderingIcon();
        if (icon == null) {
            throw new LiquidTextureException(liquid);
        }
        return icon;
    }

    public static String getLiquidSheet(LiquidStack liquid) {
        if (liquid == null || liquid.itemID <= 0) {
            return "/terrain.png";
        }
        LiquidStack canon = liquid.canonical();
        if (canon == null) {
            throw new LiquidCanonException(liquid);
        }
        return canon.getTextureSheet();
    }

    public static int[] getLiquidDisplayLists(LiquidStack liquid, World world, boolean flowing) {
        if (liquid == null) {
            return null;
        }
        if ((liquid = liquid.canonical()) == null) {
            throw new LiquidCanonException(liquid);
        }
        Map<LiquidStack, int[]> cache = flowing ? flowingRenderCache : stillRenderCache;
        int[] diplayLists = cache.get(liquid);
        if (diplayLists != null) {
            return diplayLists;
        }
        diplayLists = new int[100];
        if (liquid.itemID < Block.field_71973_m.length && Block.field_71973_m[liquid.itemID] != null) {
            LiquidRenderer.liquidBlock.baseBlock = Block.field_71973_m[liquid.itemID];
            if (!flowing) {
                LiquidRenderer.liquidBlock.texture = LiquidRenderer.getLiquidTexture(liquid);
            }
        } else if (Item.field_77698_e[liquid.itemID] != null) {
            LiquidRenderer.liquidBlock.baseBlock = Block.field_71943_B;
            LiquidRenderer.liquidBlock.texture = LiquidRenderer.getLiquidTexture(liquid);
        } else {
            return null;
        }
        cache.put(liquid, diplayLists);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2884);
        ItemStack stack = liquid.asItemStack();
        int color = stack.func_77973_b().func_82790_a(stack, 0);
        float c1 = (float)(color >> 16 & 0xFF) / 255.0f;
        float c2 = (float)(color >> 8 & 0xFF) / 255.0f;
        float c3 = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)c1, (float)c2, (float)c3, (float)1.0f);
        for (int s = 0; s < 100; ++s) {
            diplayLists[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)diplayLists[s], (int)4864);
            LiquidRenderer.liquidBlock.minX = 0.01f;
            LiquidRenderer.liquidBlock.minY = 0.0;
            LiquidRenderer.liquidBlock.minZ = 0.01f;
            LiquidRenderer.liquidBlock.maxX = 0.99f;
            LiquidRenderer.liquidBlock.maxY = (float)s / 100.0f;
            LiquidRenderer.liquidBlock.maxZ = 0.99f;
            RenderEntityBlock.renderBlock(liquidBlock, (IBlockAccess)world, 0, 0, 0, false, true);
            GL11.glEndList();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2896);
        return diplayLists;
    }

    public static class LiquidCanonException
    extends RuntimeException {
        private final LiquidStack liquid;

        public LiquidCanonException(LiquidStack liquid) {
            this.liquid = liquid;
        }

        @Override
        public String getMessage() {
            String liquidName = LiquidDictionary.findLiquidName((LiquidStack)this.liquid);
            if (liquidName == null) {
                liquidName = String.format("ID: %d Meta: %d", this.liquid.itemID, this.liquid.itemMeta);
            }
            return String.format("Liquid %s is not registered with the Liquid Dictionary. Please contact the author of the mod the liquid came from.", liquidName);
        }
    }

    public static class LiquidTextureException
    extends RuntimeException {
        private final LiquidStack liquid;

        public LiquidTextureException(LiquidStack liquid) {
            this.liquid = liquid;
        }

        @Override
        public String getMessage() {
            String liquidName = LiquidDictionary.findLiquidName((LiquidStack)this.liquid);
            if (liquidName == null) {
                liquidName = String.format("ID: %d Meta: %d", this.liquid.itemID, this.liquid.itemMeta);
            }
            return String.format("Liquid %s has no icon. Please contact the author of the mod the liquid came from.", liquidName);
        }
    }
}

