/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.blueprints;

import buildcraft.core.blueprints.BptRootIndex;
import buildcraft.core.proxy.CoreProxy;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.TreeMap;

public class BptPlayerIndex {
    private TreeMap<String, File> bluePrintsFile = new TreeMap();
    private File baseDir = new File(CoreProxy.proxy.getBuildCraftBase(), "blueprints/");
    private File file;

    public BptPlayerIndex(String filename, BptRootIndex rootIndex) throws IOException {
        this.file = new File(this.baseDir, filename);
        this.baseDir.mkdir();
        if (!this.file.exists()) {
            this.file.createNewFile();
            for (String file : rootIndex.filesSet.keySet()) {
                this.bluePrintsFile.put(file, new File(this.baseDir, file));
            }
            this.saveIndex();
        } else {
            this.loadIndex();
        }
    }

    public void loadIndex() throws IOException {
        String line;
        FileInputStream input = new FileInputStream(this.file);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)input, "8859_1"));
        while ((line = reader.readLine()) != null) {
            line = line.replaceAll("\\n", "");
            File bptFile = new File(this.baseDir, line);
            this.bluePrintsFile.put(line, bptFile);
        }
        input.close();
    }

    public void addBlueprint(File file) throws IOException {
        this.bluePrintsFile.put(file.getName(), file);
        this.saveIndex();
    }

    public void saveIndex() throws IOException {
        FileOutputStream output = new FileOutputStream(this.file);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)output, "8859_1"));
        for (String line : this.bluePrintsFile.keySet()) {
            writer.write(line);
            writer.newLine();
        }
        writer.flush();
        output.close();
    }

    public void deleteBluePrint(String fileName) {
        this.bluePrintsFile.remove(fileName);
        try {
            this.saveIndex();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String nextBpt(String name) {
        if (this.bluePrintsFile.size() == 0) {
            return null;
        }
        if (name == null) {
            return this.bluePrintsFile.firstKey();
        }
        return this.bluePrintsFile.higherKey(name);
    }

    public String prevBpt(String name) {
        if (this.bluePrintsFile.size() == 0) {
            return null;
        }
        if (name == null) {
            return this.bluePrintsFile.lastKey();
        }
        return this.bluePrintsFile.lowerKey(name);
    }
}

