/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.fuels;

import java.util.LinkedList;
import net.minecraftforge.liquids.LiquidStack;

public class IronEngineFuel {
    public static LinkedList<IronEngineFuel> fuels = new LinkedList();
    public final LiquidStack liquid;
    public final float powerPerCycle;
    public final int totalBurningTime;

    public static IronEngineFuel getFuelForLiquid(LiquidStack liquid) {
        if (liquid == null) {
            return null;
        }
        if (liquid.itemID <= 0) {
            return null;
        }
        for (IronEngineFuel fuel : fuels) {
            if (!fuel.liquid.isLiquidEqual(liquid)) continue;
            return fuel;
        }
        return null;
    }

    public IronEngineFuel(int liquidId, float powerPerCycle, int totalBurningTime) {
        this(new LiquidStack(liquidId, 1000, 0), powerPerCycle, totalBurningTime);
    }

    public IronEngineFuel(LiquidStack liquid, float powerPerCycle, int totalBurningTime) {
        this.liquid = liquid;
        this.powerPerCycle = powerPerCycle;
        this.totalBurningTime = totalBurningTime;
    }
}

