/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class NaturalTextures {
    private static bge renderEngine = null;
    private static NaturalProperties[] propertiesByIndex = new NaturalProperties[0];

    public static void update(bge re) {
        propertiesByIndex = new NaturalProperties[0];
        renderEngine = re;
        if (!Config.isNaturalTextures()) {
            return;
        }
        String fileName = "/natural.properties";
        try {
            InputStream in = re.g.e().a(fileName);
            if (in == null) {
                Config.dbg("NaturalTextures: configuration \"" + fileName + "\" not found");
                propertiesByIndex = NaturalTextures.makeDefaultProperties();
                return;
            }
            ArrayList<NaturalProperties> list = new ArrayList<NaturalProperties>(256);
            String configStr = Config.readInputStream(in);
            in.close();
            String[] configLines = Config.tokenize(configStr, "\n\r");
            Config.dbg("Natural Textures: Parsing configuration \"" + fileName + "\"");
            for (int i = 0; i < configLines.length; ++i) {
                String line = configLines[i].trim();
                if (line.startsWith("#")) continue;
                String[] strs = Config.tokenize(line, "=");
                if (strs.length != 2) {
                    Config.dbg("Natural Textures: Invalid \"" + fileName + "\" line: " + line);
                    continue;
                }
                String key = strs[0].trim();
                String type = strs[1].trim();
                String texName = key;
                bil ts = re.i.getIconSafe(texName);
                if (ts == null) {
                    Config.dbg("Natural Textures: Texture not found: \"" + fileName + "\" line: " + line);
                    continue;
                }
                int tileNum = ts.getIndexInMap();
                if (tileNum < 0) {
                    Config.dbg("Natural Textures: Invalid \"" + fileName + "\" line: " + line);
                    continue;
                }
                NaturalProperties props = new NaturalProperties(type);
                if (!props.isValid()) continue;
                while (list.size() <= tileNum) {
                    list.add(null);
                }
                list.set(tileNum, props);
            }
            propertiesByIndex = list.toArray(new NaturalProperties[list.size()]);
        }
        catch (FileNotFoundException e) {
            Config.dbg("NaturalTextures: configuration \"" + fileName + "\" not found");
            propertiesByIndex = NaturalTextures.makeDefaultProperties();
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static NaturalProperties getNaturalProperties(lx icon) {
        if (!(icon instanceof bil)) {
            return null;
        }
        bil ts = (bil)icon;
        int tileNum = ts.getIndexInMap();
        if (tileNum < 0 || tileNum >= propertiesByIndex.length) {
            return null;
        }
        NaturalProperties props = propertiesByIndex[tileNum];
        return props;
    }

    private static NaturalProperties[] makeDefaultProperties() {
        if (!(NaturalTextures.renderEngine.g.e() instanceof bjq)) {
            Config.dbg("NaturalTextures: Texture pack is not default, ignoring default configuration.");
            return new NaturalProperties[0];
        }
        Config.dbg("Natural Textures: Using default configuration.");
        ArrayList propsList = new ArrayList();
        NaturalTextures.setIconProperties(propsList, "grass_top", "4F");
        NaturalTextures.setIconProperties(propsList, "stone", "2F");
        NaturalTextures.setIconProperties(propsList, "dirt", "4F");
        NaturalTextures.setIconProperties(propsList, "grass_side", "F");
        NaturalTextures.setIconProperties(propsList, "grass_side_overlay", "F");
        NaturalTextures.setIconProperties(propsList, "stoneslab_top", "F");
        NaturalTextures.setIconProperties(propsList, "bedrock", "2F");
        NaturalTextures.setIconProperties(propsList, "sand", "4F");
        NaturalTextures.setIconProperties(propsList, "gravel", "2");
        NaturalTextures.setIconProperties(propsList, "tree_side", "2F");
        NaturalTextures.setIconProperties(propsList, "tree_top", "4F");
        NaturalTextures.setIconProperties(propsList, "oreGold", "2F");
        NaturalTextures.setIconProperties(propsList, "oreIron", "2F");
        NaturalTextures.setIconProperties(propsList, "oreCoal", "2F");
        NaturalTextures.setIconProperties(propsList, "oreDiamond", "2F");
        NaturalTextures.setIconProperties(propsList, "oreRedstone", "2F");
        NaturalTextures.setIconProperties(propsList, "oreLapis", "2F");
        NaturalTextures.setIconProperties(propsList, "obsidian", "4F");
        NaturalTextures.setIconProperties(propsList, "leaves", "2F");
        NaturalTextures.setIconProperties(propsList, "leaves_opaque", "2F");
        NaturalTextures.setIconProperties(propsList, "leaves_jungle", "2");
        NaturalTextures.setIconProperties(propsList, "leaves_jungle_opaque", "2");
        NaturalTextures.setIconProperties(propsList, "snow", "4F");
        NaturalTextures.setIconProperties(propsList, "snow_side", "F");
        NaturalTextures.setIconProperties(propsList, "cactus_side", "2F");
        NaturalTextures.setIconProperties(propsList, "clay", "4F");
        NaturalTextures.setIconProperties(propsList, "mycel_side", "F");
        NaturalTextures.setIconProperties(propsList, "mycel_top", "4F");
        NaturalTextures.setIconProperties(propsList, "farmland_wet", "2F");
        NaturalTextures.setIconProperties(propsList, "farmland_dry", "2F");
        NaturalTextures.setIconProperties(propsList, "hellrock", "4F");
        NaturalTextures.setIconProperties(propsList, "hellsand", "4F");
        NaturalTextures.setIconProperties(propsList, "lightgem", "4");
        NaturalTextures.setIconProperties(propsList, "tree_spruce", "2F");
        NaturalTextures.setIconProperties(propsList, "tree_birch", "F");
        NaturalTextures.setIconProperties(propsList, "leaves_spruce", "2F");
        NaturalTextures.setIconProperties(propsList, "leaves_spruce_opaque", "2F");
        NaturalTextures.setIconProperties(propsList, "tree_jungle", "2F");
        NaturalTextures.setIconProperties(propsList, "whiteStone", "4");
        NaturalTextures.setIconProperties(propsList, "sandstone_top", "4");
        NaturalTextures.setIconProperties(propsList, "sandstone_bottom", "4F");
        NaturalTextures.setIconProperties(propsList, "redstoneLight_lit", "4F");
        NaturalProperties[] terrainProps = propsList.toArray(new NaturalProperties[propsList.size()]);
        return terrainProps;
    }

    private static void setIconProperties(List propsList, String iconName, String propStr) {
        bir terrainMap = NaturalTextures.renderEngine.i;
        lx icon = terrainMap.a(iconName);
        if (icon == null) {
            Config.dbg("*** NaturalProperties: Icon not found: " + iconName + " ***");
            return;
        }
        if (!(icon instanceof bil)) {
            Config.dbg("*** NaturalProperties: Icon is not IconStitched: " + iconName + ": " + icon.getClass().getName() + " ***");
            return;
        }
        bil ts = (bil)icon;
        int index = ts.getIndexInMap();
        if (index < 0) {
            Config.dbg("*** NaturalProperties: Invalid index for icon: " + iconName + ": " + index + " ***");
            return;
        }
        while (index >= propsList.size()) {
            propsList.add(null);
        }
        NaturalProperties props = new NaturalProperties(propStr);
        propsList.set(index, props);
    }

    public static void updateIcons(bir textureMap) {
    }
}

