/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.treecapitator.fml.asm;

import bspkrs.treecapitator.TCLog;
import bspkrs.treecapitator.fml.TreeCapitatorMod;
import cpw.mods.fml.relauncher.IClassTransformer;
import java.util.HashMap;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ItemInWorldManagerTransformer
implements IClassTransformer {
    private final String targetMethodDesc = "(III)Z";
    private final HashMap obfStrings = new HashMap();
    private final HashMap mcpStrings;

    public ItemInWorldManagerTransformer() {
        this.obfStrings.put("className", "jd");
        this.obfStrings.put("javaClassName", "jd");
        this.obfStrings.put("targetMethodName", "d");
        this.obfStrings.put("worldFieldName", "a");
        this.obfStrings.put("entityPlayerFieldName", "b");
        this.obfStrings.put("worldJavaClassName", "aab");
        this.obfStrings.put("getBlockMetadataMethodName", "h");
        this.obfStrings.put("blockJavaClassName", "apa");
        this.obfStrings.put("blocksListFieldName", "r");
        this.obfStrings.put("entityPlayerJavaClassName", "sq");
        this.obfStrings.put("entityPlayerMPJavaClassName", "jc");
        this.mcpStrings = new HashMap();
        this.mcpStrings.put("className", "net.minecraft.item.ItemInWorldManager");
        this.mcpStrings.put("javaClassName", "net/minecraft/item/ItemInWorldManager");
        this.mcpStrings.put("targetMethodName", "removeBlock");
        this.mcpStrings.put("worldFieldName", "theWorld");
        this.mcpStrings.put("entityPlayerFieldName", "thisPlayerMP");
        this.mcpStrings.put("worldJavaClassName", "net/minecraft/world/World");
        this.mcpStrings.put("getBlockMetadataMethodName", "getBlockMetadata");
        this.mcpStrings.put("blockJavaClassName", "net/minecraft/block/Block");
        this.mcpStrings.put("blocksListFieldName", "blocksList");
        this.mcpStrings.put("entityPlayerJavaClassName", "net/minecraft/entity/player/EntityPlayer");
        this.mcpStrings.put("entityPlayerMPJavaClassName", "net/minecraft/entity/player/EntityPlayerMP");
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (name.equals(this.obfStrings.get("className"))) {
            return this.transformItemInWorldManager(bytes, this.obfStrings);
        }
        if (name.equals(this.mcpStrings.get("className"))) {
            return this.transformItemInWorldManager(bytes, this.mcpStrings);
        }
        return bytes;
    }

    private byte[] transformItemInWorldManager(byte[] bytes, HashMap hm) {
        TCLog.debug("TreeCapitator ASM Magic Time!", new Object[0]);
        TCLog.debug("Class Transformation running on " + (String)hm.get("javaClassName") + "...", new Object[0]);
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        block0: for (MethodNode m : classNode.methods) {
            if (!m.name.equals(hm.get("targetMethodName")) || !m.desc.equals("(III)Z")) continue;
            TCLog.debug("Found target method " + m.name + m.desc + "! Searching for landmarks...", new Object[0]);
            int blockIndex = 4;
            int mdIndex = 5;
            for (int index = 0; index < m.instructions.size(); ++index) {
                int offset;
                if (m.instructions.get(index).getType() == 4) {
                    FieldInsnNode blocksListNode = (FieldInsnNode)m.instructions.get(index);
                    if (blocksListNode.owner.equals(hm.get("blockJavaClassName")) && blocksListNode.name.equals(hm.get("blocksListFieldName"))) {
                        offset = 1;
                        while (m.instructions.get(index + offset).getOpcode() != 58) {
                            ++offset;
                        }
                        TCLog.debug("Found Block object ASTORE Node at " + (index + offset), new Object[0]);
                        VarInsnNode blockNode = (VarInsnNode)m.instructions.get(index + offset);
                        blockIndex = blockNode.var;
                        TCLog.debug("Block object is in local object " + blockIndex, new Object[0]);
                    }
                }
                if (m.instructions.get(index).getType() == 5) {
                    MethodInsnNode mdNode = (MethodInsnNode)m.instructions.get(index);
                    if (mdNode.owner.equals(hm.get("worldJavaClassName")) && mdNode.name.equals(hm.get("getBlockMetadataMethodName"))) {
                        offset = 1;
                        while (m.instructions.get(index + offset).getOpcode() != 54) {
                            ++offset;
                        }
                        TCLog.debug("Found metadata local variable ISTORE Node at " + (index + offset), new Object[0]);
                        VarInsnNode mdFieldNode = (VarInsnNode)m.instructions.get(index + offset);
                        mdIndex = mdFieldNode.var;
                        TCLog.debug("Metadata is in local variable " + mdIndex, new Object[0]);
                    }
                }
                if (m.instructions.get(index).getOpcode() != 198) continue;
                TCLog.debug("Found IFNULL Node at " + index, new Object[0]);
                int offset2 = 1;
                while (m.instructions.get(index + offset2).getOpcode() != 25) {
                    ++offset2;
                }
                TCLog.debug("Found ALOAD Node at offset " + offset2 + " from IFNULL Node", new Object[0]);
                TCLog.debug("Patching method " + (String)hm.get("javaClassName") + "/" + m.name + m.desc + "...", new Object[0]);
                LabelNode lmm1Node = new LabelNode(new Label());
                InsnList toInject = new InsnList();
                toInject.add((AbstractInsnNode)new FieldInsnNode(178, "bspkrs/treecapitator/fml/TreeCapitatorMod", "instance", "Lbspkrs/treecapitator/fml/TreeCapitatorMod;"));
                toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInject.add((AbstractInsnNode)new FieldInsnNode(180, (String)hm.get("javaClassName"), (String)hm.get("worldFieldName"), "L" + (String)hm.get("worldJavaClassName") + ";"));
                toInject.add((AbstractInsnNode)new VarInsnNode(21, 1));
                toInject.add((AbstractInsnNode)new VarInsnNode(21, 2));
                toInject.add((AbstractInsnNode)new VarInsnNode(21, 3));
                toInject.add((AbstractInsnNode)new VarInsnNode(25, blockIndex));
                toInject.add((AbstractInsnNode)new VarInsnNode(21, mdIndex));
                toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInject.add((AbstractInsnNode)new FieldInsnNode(180, (String)hm.get("javaClassName"), (String)hm.get("entityPlayerFieldName"), "L" + (String)hm.get("entityPlayerMPJavaClassName") + ";"));
                toInject.add((AbstractInsnNode)new MethodInsnNode(182, "bspkrs/treecapitator/fml/TreeCapitatorMod", "onBlockHarvested", "(L" + (String)hm.get("worldJavaClassName") + ";IIIL" + (String)hm.get("blockJavaClassName") + ";IL" + (String)hm.get("entityPlayerJavaClassName") + ";)V"));
                toInject.add((AbstractInsnNode)lmm1Node);
                m.instructions.insertBefore(m.instructions.get(index + offset2), toInject);
                TCLog.debug("Method " + (String)hm.get("javaClassName") + "/" + m.name + m.desc + " patched at index " + (index + offset2 - 1), new Object[0]);
                TCLog.info("TreeCapitator ASM Patching Complete!", new Object[0]);
                TreeCapitatorMod.isCoreModLoaded = true;
                continue block0;
            }
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

