/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.treecapitator.fml;

import bspkrs.fml.util.bspkrsCoreProxy;
import bspkrs.treecapitator.RegistryNBTManager;
import bspkrs.treecapitator.TCLog;
import bspkrs.treecapitator.TCSettings;
import bspkrs.treecapitator.TreeCapitator;
import bspkrs.treecapitator.TreeDefinition;
import bspkrs.treecapitator.TreeRegistry;
import bspkrs.treecapitator.fml.CommonProxy;
import bspkrs.treecapitator.fml.ConnectionHandler;
import bspkrs.treecapitator.fml.IDResolverMappingList;
import bspkrs.treecapitator.fml.ModConfigRegistry;
import bspkrs.treecapitator.fml.PlayerHandler;
import bspkrs.treecapitator.fml.TCConfigHandler;
import bspkrs.treecapitator.fml.ThirdPartyModConfig;
import bspkrs.treecapitator.fml.TreeCapitatorClient;
import bspkrs.treecapitator.fml.TreeCapitatorServer;
import bspkrs.util.BlockID;
import bspkrs.util.CommonUtils;
import bspkrs.util.Configuration;
import bspkrs.util.Coord;
import bspkrs.util.ModVersionChecker;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.network.NetworkMod;
import java.io.File;
import net.minecraftforge.common.MinecraftForge;

@Mod(name="TreeCapitator", modid="TreeCapitator", version="Forge 1.5.2.r14", dependencies="required-after:mod_bspkrsCore", useMetadata=true)
@NetworkMod(clientSideRequired=true, serverSideRequired=false, clientPacketHandlerSpec=@NetworkMod.SidedPacketHandler(channels={"TreeCapitator"}, packetHandler=TreeCapitatorClient.class), serverPacketHandlerSpec=@NetworkMod.SidedPacketHandler(channels={"TreeCapitator"}, packetHandler=TreeCapitatorServer.class), connectionHandler=ConnectionHandler.class)
public class TreeCapitatorMod {
    public static ModVersionChecker versionChecker;
    private final String versionURL = "http://bspk.rs/Minecraft/1.5.2/treeCapitatorForge.version";
    private final String mcfTopic = "http://www.minecraftforum.net/topic/1009577-";
    public static boolean isCoreModLoaded;
    private RegistryNBTManager nbtManager;
    public Configuration config;
    @Mod.Metadata(value="TreeCapitator")
    public static ModMetadata metadata;
    @SidedProxy(clientSide="bspkrs.treecapitator.fml.ClientProxy", serverSide="bspkrs.treecapitator.fml.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="TreeCapitator")
    public static TreeCapitatorMod instance;

    public TreeCapitatorMod() {
        new bspkrsCoreProxy();
    }

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent event) {
        TCSettings.preInit(true);
        metadata = event.getModMetadata();
        File file = event.getSuggestedConfigurationFile();
        if (!CommonUtils.isObfuscatedEnv()) {
            // empty if block
        }
        TreeRegistry.instance();
        IDResolverMappingList.instance();
        TCConfigHandler.setInstance(file);
        if (bspkrsCoreProxy.instance.allowUpdateCheck) {
            versionChecker = new ModVersionChecker(TreeCapitatorMod.metadata.name, TreeCapitatorMod.metadata.version, "http://bspk.rs/Minecraft/1.5.2/treeCapitatorForge.version", "http://www.minecraftforum.net/topic/1009577-");
            versionChecker.checkVersionWithLoggingBySubStringAsFloat(TreeCapitatorMod.metadata.version.length() - 2, TreeCapitatorMod.metadata.version.length());
        }
    }

    @Mod.Init
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new PlayerHandler());
        proxy.onLoad();
    }

    @Mod.IMCCallback
    public void processIMCMessages(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage msg : event.getMessages().asList()) {
            if (msg.isNBTMessage()) {
                TCLog.info("Received IMC message from mod %s.", msg.getSender());
                ModConfigRegistry.instance().registerIMCModConfig(new ThirdPartyModConfig(msg.getNBTValue()));
                continue;
            }
            TCLog.warning("Mod %s send an IMC message, but it is not an NBT object message. The message will be ignored.", msg.getSender());
        }
    }

    @Mod.PostInit
    public void postInit(FMLPostInitializationEvent event) {
        ModConfigRegistry.instance().applyPrioritizedModConfigs();
        if (Loader.isModLoaded((String)TCSettings.multiMineModID)) {
            String s = TreeRegistry.instance().getMultiMineExclusionString();
            TCLog.info("For Multi-Mine compatibility you should put this list in the S:\"Excluded Block IDs\" config setting in AS_MultiMine.cfg: \"%s\"", s);
            TCConfigHandler.instance().config.get("tree_and_mod_configs", "Excluded Block IDs", "", "For Multi-Mine compatibility you should put this list in the S:\"Excluded Block IDs\" config setting in AS_MultiMine.cfg").set(s);
            TCConfigHandler.instance().config.save();
        }
    }

    @Mod.ServerStarted
    public void serverStarted(FMLServerStartedEvent event) {
        this.nbtManager();
    }

    public void onBlockHarvested(aab world, int x, int y, int z, apa block, int metadata, sq entityPlayer) {
        if (proxy.isEnabled() && !world.I) {
            BlockID blockID = new BlockID(block, metadata);
            if (TreeRegistry.instance().isRegistered(blockID)) {
                Coord blockPos = new Coord(x, y, z);
                if (TreeRegistry.instance().trackTreeChopEventAt(blockPos)) {
                    TCLog.debug("BlockID " + blockID + " is a log.", new Object[0]);
                    if (TreeCapitator.isBreakingEnabled(entityPlayer)) {
                        if (TreeCapitator.isBreakingPossible(world, entityPlayer, true)) {
                            TreeDefinition treeDef = TreeRegistry.instance().get(blockID);
                            if (treeDef != null) {
                                TreeCapitator breaker = new TreeCapitator(entityPlayer, treeDef);
                                breaker.onBlockHarvested(world, x, y, z, metadata, entityPlayer);
                            } else {
                                TCLog.severe("TreeRegistry reported block ID %s is a log, but TreeDefinition lookup failed! Please report this to bspkrs (include a copy of this log file and your config).", blockID);
                            }
                        }
                    } else {
                        TCLog.debug("Chopping disabled due to player state or gamemode.", new Object[0]);
                    }
                }
                TreeRegistry.instance().endTreeChopEventAt(blockPos);
            }
        }
    }

    public static boolean isItemInWorldManagerReplaced(jc player) {
        return !player.c.getClass().getSimpleName().equals(jd.class.getSimpleName());
    }

    public RegistryNBTManager nbtManager() {
        if (this.nbtManager == null) {
            this.nbtManager = new RegistryNBTManager();
        }
        return this.nbtManager;
    }

    static {
        isCoreModLoaded = false;
    }
}

