/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.treecapitator.fml;

import bspkrs.treecapitator.ConfigTreeDefinition;
import bspkrs.treecapitator.TCLog;
import bspkrs.treecapitator.TCSettings;
import bspkrs.treecapitator.ToolRegistry;
import bspkrs.treecapitator.TreeDefinition;
import bspkrs.treecapitator.TreeRegistry;
import bspkrs.treecapitator.fml.IDResolverMapping;
import bspkrs.treecapitator.fml.IDResolverMappingList;
import bspkrs.treecapitator.fml.TreeCapitatorMod;
import bspkrs.util.CommonUtils;
import bspkrs.util.ConfigCategory;
import bspkrs.util.Configuration;
import bspkrs.util.ItemID;
import bspkrs.util.ListUtils;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ThirdPartyModConfig {
    private String modID;
    private String configPath;
    private String blockKeys;
    private String itemKeys;
    private String axeKeys;
    private String shearsKeys;
    private boolean shiftIndex;
    private boolean overrideIMC;
    private Map configTreesMap;
    private Map treesMap;
    private Map tagMap;

    protected ThirdPartyModConfig(boolean init) {
        this.modID = TreeCapitatorMod.metadata.modId;
        this.configPath = "";
        this.blockKeys = "";
        this.itemKeys = "";
        this.shiftIndex = false;
        this.overrideIMC = TCSettings.userConfigOverridesIMC;
        this.tagMap = new HashMap();
        this.treesMap = new TreeMap();
        if (init) {
            this.axeKeys = ListUtils.getListAsDelimitedString((List)ToolRegistry.instance().vanillaAxeList(), (String)"; ");
            this.shearsKeys = ListUtils.getListAsDelimitedString((List)ToolRegistry.instance().vanillaShearsList(), (String)"; ");
            this.configTreesMap = TreeRegistry.instance().vanillaTrees();
            this.refreshTreeDefinitionsFromConfig();
        } else {
            this.axeKeys = "";
            this.shearsKeys = "";
            this.configTreesMap = new TreeMap();
        }
    }

    protected ThirdPartyModConfig() {
        this(true);
    }

    public ThirdPartyModConfig(String modID, String configPath, String blockKeys, String itemKeys, String axeKeys, String shearsKeys, boolean shiftIndex) {
        this.modID = modID;
        this.configPath = configPath;
        this.blockKeys = blockKeys;
        this.itemKeys = itemKeys;
        this.axeKeys = axeKeys;
        this.shearsKeys = shearsKeys;
        this.shiftIndex = shiftIndex;
        this.overrideIMC = TCSettings.userConfigOverridesIMC;
        this.configTreesMap = new TreeMap();
        this.treesMap = new TreeMap();
    }

    public ThirdPartyModConfig(String modID, String configPath, String blockKeys) {
        this(modID, configPath, blockKeys, "", "", "", true);
    }

    public ThirdPartyModConfig(String modID, String configPath, String itemKeys, String axeKeys, String shearsKeys, boolean shiftIndex) {
        this(modID, configPath, "", itemKeys, axeKeys, shearsKeys, shiftIndex);
    }

    public ThirdPartyModConfig(Configuration config, String category) {
        this(false);
        this.readFromConfiguration(config, category);
    }

    public ThirdPartyModConfig(bs tpModCfg) {
        this(false);
        this.readFromNBT(tpModCfg);
    }

    public ThirdPartyModConfig readFromNBT(bs tpModCfg) {
        this.modID = tpModCfg.i("modID");
        if (tpModCfg.b("configPath")) {
            this.configPath = tpModCfg.i("configPath");
        }
        if (tpModCfg.b("blockConfigKeys")) {
            this.blockKeys = tpModCfg.i("blockConfigKeys");
        }
        if (tpModCfg.b("itemConfigKeys")) {
            this.itemKeys = tpModCfg.i("itemConfigKeys");
        }
        if (tpModCfg.b("axeIDList")) {
            this.axeKeys = tpModCfg.i("axeIDList");
        }
        if (tpModCfg.b("shearsIDList")) {
            this.shearsKeys = tpModCfg.i("shearsIDList");
        }
        if (tpModCfg.b("useShiftedItemID")) {
            this.shiftIndex = tpModCfg.n("useShiftedItemID");
        }
        this.configTreesMap = new TreeMap();
        ca treeList = tpModCfg.m("trees");
        for (int i = 0; i < treeList.c(); ++i) {
            bs tree = (bs)treeList.b(i);
            this.addConfigTreeDef(tree.i("treeName"), new ConfigTreeDefinition(tree));
        }
        return this;
    }

    public void writeToNBT(bs tpModCfg) {
        tpModCfg.p(this.modID);
        tpModCfg.a("modID", this.modID);
        if (this.configPath.length() > 0) {
            tpModCfg.a("configPath", this.configPath);
        }
        if (this.blockKeys.length() > 0) {
            tpModCfg.a("blockConfigKeys", this.blockKeys);
        }
        if (this.itemKeys.length() > 0) {
            tpModCfg.a("itemConfigKeys", this.itemKeys);
        }
        if (this.axeKeys.length() > 0) {
            tpModCfg.a("axeIDList", this.axeKeys);
        }
        if (this.shearsKeys.length() > 0) {
            tpModCfg.a("shearsIDList", this.shearsKeys);
        }
        tpModCfg.a("useShiftedItemID", this.shiftIndex);
        ca treeList = new ca();
        for (Map.Entry e : this.configTreesMap.entrySet()) {
            bs tree = new bs();
            ((ConfigTreeDefinition)e.getValue()).writeToNBT(tree);
            tree.a("treeName", (String)e.getKey());
            treeList.a((cf)tree);
        }
        tpModCfg.a("trees", (cf)treeList);
    }

    public ThirdPartyModConfig readFromConfiguration(Configuration config, String category) {
        ConfigCategory cc = config.getCategory(category);
        this.modID = cc.get("modID").getString();
        if (cc.containsKey("configPath")) {
            this.configPath = cc.get("configPath").getString();
        }
        if (cc.containsKey("blockConfigKeys")) {
            this.blockKeys = cc.get("blockConfigKeys").getString();
        }
        if (cc.containsKey("itemConfigKeys")) {
            this.itemKeys = cc.get("itemConfigKeys").getString();
        }
        if (cc.containsKey("axeIDList")) {
            this.axeKeys = cc.get("axeIDList").getString();
        }
        if (cc.containsKey("shearsIDList")) {
            this.shearsKeys = cc.get("shearsIDList").getString();
        }
        if (cc.containsKey("itemConfigKeys")) {
            this.shiftIndex = cc.get("useShiftedItemID").getBoolean(false);
        }
        if (cc.containsKey("overrideIMC")) {
            this.overrideIMC = cc.get("overrideIMC").getBoolean(TCSettings.userConfigOverridesIMC);
        }
        this.configTreesMap = new TreeMap();
        for (String ctgy : config.getCategoryNames()) {
            if (ctgy.indexOf(category + ".") == -1) continue;
            this.addConfigTreeDef(config.getCategory(ctgy).getName(), new ConfigTreeDefinition(config, ctgy));
        }
        return this;
    }

    public void writeToConfiguration(Configuration config, String category) {
        config.get(category, "modID", this.modID);
        if (this.configPath.length() > 0) {
            config.get(category, "configPath", this.configPath);
        }
        if (this.blockKeys.length() > 0) {
            config.get(category, "blockConfigKeys", this.blockKeys);
        }
        if (this.itemKeys.length() > 0) {
            config.get(category, "itemConfigKeys", this.itemKeys);
        }
        if (this.axeKeys.length() > 0) {
            config.get(category, "axeIDList", this.axeKeys);
        }
        if (this.shearsKeys.length() > 0) {
            config.get(category, "shearsIDList", this.shearsKeys);
        }
        if (this.itemKeys.length() > 0) {
            config.get(category, "useShiftedItemID", this.shiftIndex);
        }
        config.get(category, "overrideIMC", this.overrideIMC);
        for (Map.Entry e : this.configTreesMap.entrySet()) {
            ((ConfigTreeDefinition)e.getValue()).writeToConfiguration(config, category + "." + (String)e.getKey());
        }
    }

    public ThirdPartyModConfig addConfigTreeDef(String key, ConfigTreeDefinition tree) {
        if (!this.configTreesMap.containsKey(key)) {
            this.configTreesMap.put(key, tree);
        } else {
            TCLog.warning("Mod %s attempted to add two tree configs with the same name: %s", this.modID, key);
        }
        return this;
    }

    public ThirdPartyModConfig addTreeDef(String key, TreeDefinition tree) {
        if (!this.treesMap.containsKey(key)) {
            this.treesMap.put(key, tree);
        } else {
            TCLog.warning("Mod %s attempted to add two tree definitions with the same id: %s", this.modID, key);
        }
        return this;
    }

    public ThirdPartyModConfig registerTrees() {
        this.refreshTreeDefinitionsFromConfig();
        for (Map.Entry e : this.treesMap.entrySet()) {
            TreeRegistry.instance().registerTree((String)e.getKey(), (TreeDefinition)e.getValue());
        }
        return this;
    }

    public ThirdPartyModConfig registerTools() {
        String axeList = this.axeKeys;
        String shearsList = this.shearsKeys;
        for (Map.Entry e : this.tagMap.entrySet()) {
            axeList = axeList.replace((CharSequence)e.getKey(), (CharSequence)e.getValue());
            shearsList = shearsList.replace((CharSequence)e.getKey(), (CharSequence)e.getValue());
        }
        for (ItemID axe : ListUtils.getDelimitedStringAsItemIDList((String)axeList, (String)";")) {
            if (axe.id <= 0) continue;
            ToolRegistry.instance().registerAxe(axe);
        }
        for (ItemID shears : ListUtils.getDelimitedStringAsItemIDList((String)shearsList, (String)";")) {
            if (shears.id <= 0) continue;
            ToolRegistry.instance().registerShears(shears);
        }
        return this;
    }

    public String modID() {
        return this.modID;
    }

    public String configPath() {
        return this.configPath;
    }

    public String blockKeys() {
        return this.blockKeys;
    }

    public boolean shiftIndex() {
        return this.shiftIndex;
    }

    public boolean overrideIMC() {
        return this.overrideIMC;
    }

    public ThirdPartyModConfig setOverrideIMC(boolean bol) {
        this.overrideIMC = bol;
        return this;
    }

    public ThirdPartyModConfig refreshTreeDefinitionsFromConfig() {
        this.treesMap.clear();
        for (Map.Entry e : this.configTreesMap.entrySet()) {
            this.treesMap.put(e.getKey(), ((ConfigTreeDefinition)e.getValue()).getTagsReplacedTreeDef(this.tagMap));
        }
        return this;
    }

    protected void refreshReplacementTags() {
        this.tagMap = new HashMap();
        if (this.configPath.length() > 0) {
            TCLog.debug("Processing Mod %s config file %s...", this.modID, this.configPath);
            if (Loader.isModLoaded((String)this.modID)) {
                File file = new File(Loader.instance().getConfigDir(), this.configPath.trim());
                if (file.exists()) {
                    Configuration thirdPartyConfig = new Configuration(file);
                    String idrClassName = ((ModContainer)Loader.instance().getIndexedModList().get(this.modID)).getMod().getClass().getName();
                    thirdPartyConfig.load();
                    this.getReplacementTagsForKeys(thirdPartyConfig, this.blockKeys, idrClassName, false);
                    this.getReplacementTagsForKeys(thirdPartyConfig, this.itemKeys, idrClassName, true);
                } else {
                    TCLog.warning("Mod config file %s does not exist when processing Mod %s.", this.configPath, this.modID);
                }
            } else {
                TCLog.debug("Mod %s is not loaded.", this.modID);
            }
        } else {
            TCLog.debug("configPath property is blank for mod %s.", this.modID);
        }
    }

    private void getReplacementTagsForKeys(Configuration thirdPartyConfig, String keys, String idrClassName, boolean isItemList) {
        if (keys.length() > 0) {
            for (String configID : keys.trim().split(";")) {
                String[] subString = configID.trim().split(":");
                String configValue = thirdPartyConfig.get(subString[0].trim(), subString[1].trim(), 0).getString();
                String tagID = "<" + subString[0].trim() + ":" + subString[1].trim() + ">";
                if (!this.tagMap.containsKey(tagID)) {
                    IDResolverMapping mapping = IDResolverMappingList.instance().getMappingForModAndOldID(idrClassName, CommonUtils.parseInt((String)configValue));
                    if (mapping != null) {
                        configValue = String.valueOf(mapping.newID);
                    }
                    if (isItemList && this.shiftIndex) {
                        configValue = String.valueOf(CommonUtils.parseInt((String)configValue, (int)-256) + 256);
                    }
                    if (configValue.equals("0")) continue;
                    this.tagMap.put(tagID, configValue);
                    TCLog.debug("Third Party Mod Config Tag %s will map to %s for mod %s", tagID, configValue, this.modID);
                    continue;
                }
                TCLog.warning("Duplicate Third Party Config Tag detected: " + tagID + " is already mapped to " + (String)this.tagMap.get(tagID), new Object[0]);
            }
        }
    }
}

