/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.treecapitator;

import bspkrs.treecapitator.ConfigTreeDefinition;
import bspkrs.treecapitator.TCLog;
import bspkrs.treecapitator.TCSettings;
import bspkrs.treecapitator.TreeDefinition;
import bspkrs.util.BlockID;
import bspkrs.util.Coord;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class TreeRegistry {
    private Map treeDefs;
    private Map logToStringMap;
    private TreeDefinition masterDefinition;
    private Map vanTrees;
    private List blocksBeingChopped;
    private static TreeRegistry instance;

    public static TreeRegistry instance() {
        if (instance == null) {
            new TreeRegistry();
        }
        return instance;
    }

    protected TreeRegistry() {
        instance = this;
        this.initMapsAndLists();
        this.initVanillaTreeDefs();
    }

    protected void initMapsAndLists() {
        this.treeDefs = new HashMap();
        this.logToStringMap = new HashMap();
        this.masterDefinition = new TreeDefinition();
        this.blocksBeingChopped = new ArrayList();
    }

    protected void initVanillaTreeDefs() {
        this.vanTrees = new TreeMap();
        this.vanTrees.put("vanilla_oak", new ConfigTreeDefinition().addLogID(new BlockID(17, 0)).addLogID(new BlockID(17, 4)).addLogID(new BlockID(17, 8)).addLogID(new BlockID(17, 12)).addLeafID(new BlockID(18, 0)).addLeafID(new BlockID(18, 8)));
        this.vanTrees.put("vanilla_spruce", new ConfigTreeDefinition().addLogID(new BlockID(17, 1)).addLogID(new BlockID(17, 5)).addLogID(new BlockID(17, 9)).addLogID(new BlockID(17, 13)).addLeafID(new BlockID(18, 1)).addLeafID(new BlockID(18, 9)));
        this.vanTrees.put("vanilla_birch", new ConfigTreeDefinition().addLogID(new BlockID(17, 2)).addLogID(new BlockID(17, 6)).addLogID(new BlockID(17, 10)).addLogID(new BlockID(17, 14)).addLeafID(new BlockID(18, 2)).addLeafID(new BlockID(18, 10)));
        this.vanTrees.put("vanilla_jungle", new ConfigTreeDefinition().addLogID(new BlockID(17, 3)).addLogID(new BlockID(17, 7)).addLogID(new BlockID(17, 11)).addLogID(new BlockID(17, 15)).addLeafID(new BlockID(18, 3)).addLeafID(new BlockID(18, 11)).addLeafID(new BlockID(18, 0)).addLeafID(new BlockID(18, 8)).setMaxHorLeafBreakDist(6).setRequireLeafDecayCheck(false));
        this.vanTrees.put("vanilla_huge_brown_mushroom", new ConfigTreeDefinition().addLogID(new BlockID(99, 10)).addLogID(new BlockID(99, 15)).addLeafID(new BlockID(99, 1)).addLeafID(new BlockID(99, 2)).addLeafID(new BlockID(99, 3)).addLeafID(new BlockID(99, 4)).addLeafID(new BlockID(99, 5)).addLeafID(new BlockID(99, 6)).addLeafID(new BlockID(99, 7)).addLeafID(new BlockID(99, 8)).addLeafID(new BlockID(99, 9)).addLeafID(new BlockID(99, 14)).setMaxHorLeafBreakDist(6).setRequireLeafDecayCheck(false));
        this.vanTrees.put("vanilla_huge_red_mushroom", new ConfigTreeDefinition().addLogID(new BlockID(100, 10)).addLogID(new BlockID(100, 15)).addLeafID(new BlockID(100, 1)).addLeafID(new BlockID(100, 2)).addLeafID(new BlockID(100, 3)).addLeafID(new BlockID(100, 4)).addLeafID(new BlockID(100, 5)).addLeafID(new BlockID(100, 6)).addLeafID(new BlockID(100, 7)).addLeafID(new BlockID(100, 8)).addLeafID(new BlockID(100, 9)).addLeafID(new BlockID(100, 14)).setMaxHorLeafBreakDist(6).setRequireLeafDecayCheck(false));
    }

    protected void registerVanillaTreeDefs() {
        for (Map.Entry e : this.vanTrees.entrySet()) {
            this.registerTree((String)e.getKey(), (TreeDefinition)e.getValue());
        }
    }

    public void registerTree(String newKey, TreeDefinition newTD) {
        if (newTD != null) {
            LinkedList sharedLogTrees = new LinkedList();
            HashMap<BlockID, String> toAdd = new HashMap<BlockID, String>();
            for (BlockID blockID : newTD.getLogList()) {
                if (!this.isRegistered(blockID)) {
                    toAdd.put(blockID, newKey);
                    continue;
                }
                if (!this.logToStringMap.containsKey(blockID) || sharedLogTrees.contains(this.logToStringMap.get(blockID))) continue;
                sharedLogTrees.add(this.logToStringMap.get(blockID));
            }
            if (!newKey.trim().isEmpty() && !this.isRegistered(newKey) && sharedLogTrees.size() == 0) {
                TCLog.debug("Tree Definition \"%s\" is new.  Proceeding to insert new key.", newKey);
                this.treeDefs.put(newKey, newTD);
                this.logToStringMap.putAll(toAdd);
            } else if (!newKey.trim().isEmpty()) {
                if (sharedLogTrees.size() > 0) {
                    for (String existingKey : sharedLogTrees) {
                        TCLog.debug("Tree Definition \"%s\" contains a log that is registered with an existing tree (%s).  The existing definition will be merged with the new tree.", newKey, existingKey);
                        newTD.appendWithSettings((TreeDefinition)this.treeDefs.remove(existingKey));
                    }
                    this.treeDefs.put(newKey, newTD);
                    for (BlockID blockID : newTD.getLogList()) {
                        this.logToStringMap.put(blockID, newKey);
                    }
                } else {
                    TCLog.debug("\"%s\" is already registered.  The new definition will be appended to the existing entry.", newKey);
                    ((TreeDefinition)this.treeDefs.get(newKey)).appendWithSettings(newTD);
                    this.logToStringMap.putAll(toAdd);
                }
            } else if (sharedLogTrees.size() == 1) {
                String existingTree = (String)sharedLogTrees.remove(0);
                ((TreeDefinition)this.treeDefs.get(existingTree)).appendWithSettings(newTD);
                for (BlockID log : newTD.getLogList()) {
                    if (this.logToStringMap.containsKey(log)) continue;
                    this.logToStringMap.put(log, existingTree);
                }
                this.masterDefinition.append(newTD);
            } else {
                TCLog.warning("TreeDefinition cannot be registered with an empty Key.", new Object[0]);
                return;
            }
            if (!newKey.trim().isEmpty()) {
                this.masterDefinition.append((TreeDefinition)this.treeDefs.get(newKey));
            }
        } else {
            TCLog.warning("TreeDefinition cannot be null when registering a tree!", new Object[0]);
        }
    }

    public boolean trackTreeChopEventAt(Coord c) {
        if (!this.blocksBeingChopped.contains(c)) {
            this.blocksBeingChopped.add(c);
            return true;
        }
        return false;
    }

    public void endTreeChopEventAt(Coord c) {
        if (this.blocksBeingChopped.contains(c)) {
            this.blocksBeingChopped.remove(c);
        }
    }

    public String getMultiMineExclusionString() {
        String r = "";
        ArrayList<Integer> processed = new ArrayList<Integer>();
        for (BlockID log : this.masterDefinition.logBlocks) {
            if (processed.contains(log.id)) continue;
            processed.add(log.id);
            r = r + "," + log.id;
        }
        return r.replaceFirst(",", "");
    }

    public TreeDefinition masterDefinition() {
        return this.masterDefinition;
    }

    public boolean isRegistered(String key) {
        return this.treeDefs.containsKey(key);
    }

    public boolean isRegistered(BlockID log) {
        return this.masterDefinition.isLogBlock(log);
    }

    public TreeDefinition get(String key) {
        if (this.isRegistered(key)) {
            return (TreeDefinition)this.treeDefs.get(key);
        }
        return null;
    }

    public TreeDefinition get(BlockID blockID) {
        if (this.isRegistered(blockID)) {
            if (TCSettings.useStrictBlockPairing) {
                String treeKey = (String)this.logToStringMap.get(blockID);
                TreeDefinition treeDef = this.get((String)this.logToStringMap.get(blockID));
                if (treeDef != null) {
                    return treeDef;
                }
                if (blockID.metadata > -1) {
                    treeKey = (String)this.logToStringMap.get(new BlockID(blockID.id));
                    return this.get(treeKey);
                }
            }
            return this.masterDefinition;
        }
        return null;
    }

    public List masterLogList() {
        return this.masterDefinition.getLogList();
    }

    public List masterLeafList() {
        return this.masterDefinition.getLeafList();
    }

    public Map vanillaTrees() {
        return new TreeMap(this.vanTrees);
    }

    protected void readFromNBT(bs ntc) {
        int i;
        this.treeDefs = new HashMap();
        ca l = ntc.m("treeDefs");
        for (i = 0; i < l.c(); ++i) {
            bs treeNBT = (bs)l.b(i);
            this.treeDefs.put(treeNBT.i("treeName"), new TreeDefinition(treeNBT));
        }
        this.logToStringMap = new HashMap();
        l = ntc.m("logToStringMap");
        for (i = 0; i < l.c(); ++i) {
            ce s = (ce)l.b(i);
            String[] t = s.a.split("=");
            this.logToStringMap.put(new BlockID(t[0], ","), t[1]);
        }
        this.masterDefinition = new TreeDefinition(ntc.l("masterDefinition"));
    }

    public void writeToNBT(bs ntc) {
        ca trees = new ca();
        trees.p("treeDefs");
        for (Map.Entry e : this.treeDefs.entrySet()) {
            bs tree = new bs();
            ((TreeDefinition)e.getValue()).writeToNBT(tree);
            tree.a("treeName", (String)e.getKey());
            trees.a((cf)tree);
        }
        ntc.a("treeDefs", (cf)trees);
        ca entries = new ca();
        entries.p("logToStringMap");
        for (Map.Entry e : this.logToStringMap.entrySet()) {
            ce s = new ce("", e.getKey() + "=" + (String)e.getValue());
            entries.a((cf)s);
        }
        ntc.a("logToStringMap", (cf)entries);
        bs md = new bs();
        this.masterDefinition.writeToNBT(md);
        ntc.a("masterDefinition", (cf)md);
    }
}

