/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.treecapitator;

import bspkrs.treecapitator.TCLog;
import bspkrs.treecapitator.TCSettings;
import bspkrs.treecapitator.ToolRegistry;
import bspkrs.treecapitator.TreeDefinition;
import bspkrs.treecapitator.TreeRegistry;
import bspkrs.util.BlockID;
import bspkrs.util.CommonUtils;
import bspkrs.util.Coord;
import java.util.ArrayList;
import java.util.List;

public class TreeCapitator {
    public sq player;
    private Coord startPos;
    private wm axe;
    private wm shears;
    private final TreeDefinition treeDef;
    private final List masterLogList;
    private final BlockID vineID;
    private float currentAxeDamage;
    private float currentShearsDamage = 0.0f;
    private int numLogsBroken;
    private int numLeavesSheared;
    private float logDamageMultiplier;
    private float leafDamageMultiplier;

    public TreeCapitator(sq entityPlayer, TreeDefinition treeDef) {
        this.player = entityPlayer;
        this.treeDef = treeDef;
        this.masterLogList = TreeRegistry.instance().masterLogList();
        this.vineID = new BlockID(apa.by.cz);
        this.logDamageMultiplier = TCSettings.damageMultiplier;
        this.leafDamageMultiplier = TCSettings.damageMultiplier;
        this.numLogsBroken = 1;
        this.numLeavesSheared = 1;
    }

    public static boolean isBreakingPossible(aab world, sq entityPlayer, boolean shouldLog) {
        wm axe = entityPlayer.cd();
        if (TreeCapitator.isAxeItemEquipped(entityPlayer) || !TCSettings.needItem) {
            if (!entityPlayer.ce.d && TCSettings.allowItemDamage && axe != null && axe.g() && (float)(axe.l() - axe.k()) <= TCSettings.damageMultiplier && !TCSettings.allowMoreBlocksThanDamage) {
                if (shouldLog) {
                    TCLog.debug("Chopping disabled due to axe durability.", new Object[0]);
                }
                return false;
            }
            return true;
        }
        if (shouldLog) {
            TCLog.debug("Player does not have an axe equipped.", new Object[0]);
        }
        return false;
    }

    public static boolean isBreakingEnabled(sq player) {
        return (TCSettings.sneakAction.equalsIgnoreCase("none") || TCSettings.sneakAction.equalsIgnoreCase("disable") && !player.ag() || TCSettings.sneakAction.equalsIgnoreCase("enable") && player.ag()) && (!player.ce.d || !TCSettings.disableInCreative);
    }

    public static int getTreeHeight(TreeDefinition tree, aab world, int x, int y, int z, int md, sq entityPlayer) {
        Coord startPos = new Coord(x, y, z);
        if (TreeCapitator.isBreakingPossible(world, entityPlayer, false)) {
            if (!tree.onlyDestroyUpwards()) {
                startPos = TreeCapitator.getBottomLog(tree.logBlocks, world, startPos, false);
            }
            Coord topLog = TreeCapitator.getTopLog(tree.logBlocks, world, new Coord(x, y, z), false);
            if (!tree.allowSmartTreeDetection() || tree.leafBlocks.size() == 0 || TreeCapitator.hasXLeavesInDist(tree.leafBlocks, world, topLog, tree.maxLeafIDDist(), tree.minLeavesToID(), false)) {
                return topLog.y - startPos.y + 1;
            }
        }
        return 1;
    }

    public void onBlockHarvested(aab world, int x, int y, int z, int md, sq entityPlayer) {
        if (!world.I) {
            TCLog.debug("In TreeCapitator.onBlockHarvested() " + x + ", " + y + ", " + z, new Object[0]);
            this.player = entityPlayer;
            this.startPos = new Coord(x, y, z);
            if (TreeCapitator.isBreakingEnabled(entityPlayer)) {
                Coord topLog = this.getTopLog(world, new Coord(x, y, z));
                if (!this.treeDef.allowSmartTreeDetection() || this.treeDef.leafBlocks.size() == 0 || this.hasXLeavesInDist(world, topLog, this.treeDef.maxLeafIDDist(), this.treeDef.minLeavesToID())) {
                    if (this.isAxeItemEquipped() || !TCSettings.needItem) {
                        TCLog.debug("Proceeding to chop tree...", new Object[0]);
                        ArrayList listFinal = new ArrayList();
                        TCLog.debug("Finding log blocks...", new Object[0]);
                        List logs = this.addLogs(world, new Coord(x, y, z));
                        this.addLogsAbove(world, new Coord(x, y, z), listFinal);
                        TCLog.debug("Destroying %d log blocks...", logs.size());
                        this.destroyBlocks(world, logs);
                        if (this.numLogsBroken > 1) {
                            TCLog.debug("Number of logs broken: %d", this.numLogsBroken);
                        }
                        if (TCSettings.destroyLeaves && this.treeDef.leafBlocks.size() != 0) {
                            TCLog.debug("Finding leaf blocks...", new Object[0]);
                            ArrayList leaves = new ArrayList();
                            for (Coord pos : listFinal) {
                                this.addLeaves(world, pos, leaves);
                            }
                            TCLog.debug("Destroying %d leaf blocks...", leaves.size());
                            this.destroyBlocksWithChance(world, leaves, 0.5f, this.hasShearsInHotbar(this.player));
                            if (this.numLeavesSheared > 1) {
                                TCLog.debug("Number of leaves sheared: %d", this.numLeavesSheared);
                            }
                        }
                        if (this.currentAxeDamage > 0.0f && this.axe != null) {
                            this.currentAxeDamage = Math.round(this.currentAxeDamage);
                            for (int i = 0; i < kx.c((double)this.currentAxeDamage); ++i) {
                                this.axe.b().a(this.axe, world, 17, x, y, z, (ng)this.player);
                            }
                        }
                        if (this.currentShearsDamage > 0.0f && this.shears != null) {
                            this.currentShearsDamage = Math.round(this.currentShearsDamage);
                            int i = 0;
                            while ((double)i < Math.floor(this.currentShearsDamage)) {
                                if (TCSettings.isForge && this.shears.c == wk.bf.cp) {
                                    this.shears.a(1, (ng)this.player);
                                } else {
                                    this.shears.b().a(this.shears, world, 18, x, y, z, (ng)this.player);
                                }
                                ++i;
                            }
                        }
                    } else {
                        TCLog.debug("Axe item is not equipped.", new Object[0]);
                    }
                } else {
                    TCLog.debug("Could not identify tree.", new Object[0]);
                }
            } else {
                TCLog.debug("Tree Chopping is disabled due to player state or gamemode.", new Object[0]);
            }
        } else {
            TCLog.debug("World is remote, skipping TreeCapitator.onBlockHarvested().", new Object[0]);
        }
    }

    public float getBlockHardness() {
        return this.isAxeItemEquipped() ? TCSettings.logHardnessModified : TCSettings.logHardnessNormal;
    }

    public static float getBlockHardness(sq entityPlayer) {
        return TreeCapitator.isAxeItemEquipped(entityPlayer) ? TCSettings.logHardnessModified : TCSettings.logHardnessNormal;
    }

    private Coord getTopLog(aab world, Coord pos) {
        return TreeCapitator.getTopLog(this.treeDef.logBlocks, world, pos, true);
    }

    private static Coord getTopLog(List logs, aab world, Coord pos, boolean shouldLog) {
        while (logs.contains(new BlockID(world, pos.x, pos.y + 1, pos.z))) {
            ++pos.y;
        }
        if (shouldLog) {
            TCLog.debug("Top Log: " + pos.x + ", " + pos.y + ", " + pos.z, new Object[0]);
        }
        return pos;
    }

    private static Coord getBottomLog(List logs, aab world, Coord pos, boolean shouldLog) {
        while (logs.contains(new BlockID(world, pos.x, pos.y - 1, pos.z))) {
            --pos.y;
        }
        if (shouldLog) {
            TCLog.debug("Bottom Log: " + pos.x + ", " + pos.y + ", " + pos.z, new Object[0]);
        }
        return pos;
    }

    private static boolean hasXLeavesInDist(List leaves, aab world, Coord pos, int range, int limit, boolean shouldLog) {
        if (shouldLog) {
            TCLog.debug("Attempting to identify tree...", new Object[0]);
        }
        int i = 0;
        for (int x = -range; x <= range; ++x) {
            for (int y = -1; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    BlockID blockID = new BlockID(world, pos.x + x, pos.y + y, pos.z + z);
                    if (blockID.id <= 0) continue;
                    if (TreeCapitator.isLeafBlock(leaves, blockID)) {
                        if (shouldLog) {
                            TCLog.debug("Found leaf block: %s", blockID);
                        }
                        if (++i < limit) continue;
                        return true;
                    }
                    if (!shouldLog) continue;
                    TCLog.debug("Not a leaf block: %s", blockID);
                }
            }
        }
        if (shouldLog) {
            TCLog.debug("Number of leaf blocks is less than the limit. Found: %s", i);
        }
        return false;
    }

    private boolean hasXLeavesInDist(aab world, Coord pos, int range, int limit) {
        return TreeCapitator.hasXLeavesInDist(this.treeDef.leafBlocks, world, pos, range, limit, true);
    }

    private boolean isAxeItemEquipped() {
        wm item = this.player.cd();
        if (TCSettings.enableEnchantmentMode) {
            if (item != null && item.x()) {
                for (int i = 0; i < item.r().c(); ++i) {
                    bs tag = (bs)item.r().b(i);
                    if (tag.d("id") != TCSettings.treecapitating.z) continue;
                    this.axe = item;
                    return true;
                }
            }
            this.axe = null;
            return false;
        }
        if (ToolRegistry.instance().isAxe(item)) {
            this.axe = item;
            return true;
        }
        this.axe = null;
        return false;
    }

    private int getFortuneLevel(wm itemStack) {
        ca list;
        if (itemStack != null && (list = itemStack.r()) != null) {
            for (int i = 0; i < list.c(); ++i) {
                bs tag = (bs)list.b(i);
                if (tag.d("id") != yz.u.z) continue;
                return tag.d("lvl");
            }
        }
        return 0;
    }

    public static boolean isAxeItemEquipped(sq entityPlayer) {
        wm item = entityPlayer.cd();
        if (TCSettings.enableEnchantmentMode) {
            if (item != null && item.x()) {
                for (int i = 0; i < item.r().c(); ++i) {
                    bs tag = (bs)item.r().b(i);
                    if (tag.d("id") != TCSettings.treecapitating.z) continue;
                    return true;
                }
            }
            return false;
        }
        return ToolRegistry.instance().isAxe(item);
    }

    private boolean hasShearsInHotbar(sq entityplayer) {
        return this.shearsHotbarIndex(entityplayer) != -1;
    }

    private int shearsHotbarIndex(sq entityPlayer) {
        for (int i = 0; i < 9; ++i) {
            wm item = entityPlayer.bK.a[i];
            if (item == null || item.a <= 0 || !ToolRegistry.instance().isShears(item)) continue;
            this.shears = item;
            return i;
        }
        this.shears = null;
        return -1;
    }

    public static boolean isLeafBlock(List leaves, BlockID blockID) {
        return leaves.contains(blockID) || leaves.contains(new BlockID(blockID.id, blockID.metadata & 7));
    }

    public boolean isLeafBlock(BlockID blockID) {
        return TreeCapitator.isLeafBlock(this.treeDef.leafBlocks, blockID);
    }

    private void destroyBlocks(aab world, List list) {
        this.destroyBlocksWithChance(world, list, 1.0f, false);
    }

    private void destroyBlocksWithChance(aab world, List list, float f, boolean canShear) {
        while (list.size() > 0) {
            Coord pos = (Coord)list.remove(0);
            int id = world.a(pos.x, pos.y, pos.z);
            if (id == 0) continue;
            apa block = apa.r[id];
            int metadata = world.h(pos.x, pos.y, pos.z);
            if ((this.vineID.equals((Object)new BlockID(block, metadata)) && TCSettings.shearVines || this.isLeafBlock(new BlockID(block, metadata)) && TCSettings.shearLeaves) && canShear && (!this.player.ce.d || !TCSettings.disableCreativeDrops)) {
                world.d((mp)new rh(world, (double)pos.x, (double)pos.y, (double)pos.z, new wm(id, 1, block.a(metadata))));
                if (TCSettings.allowItemDamage && !this.player.ce.d && this.shears != null && this.shears.a > 0) {
                    canShear = this.damageShearsAndContinue(world, id, pos.x, pos.y, pos.z);
                    ++this.numLeavesSheared;
                    if (canShear && TCSettings.useIncreasingItemDamage && this.numLeavesSheared % TCSettings.increaseDamageEveryXBlocks == 0) {
                        this.leafDamageMultiplier += TCSettings.damageIncreaseAmount;
                    }
                }
            } else if (!this.player.ce.d || !TCSettings.disableCreativeDrops) {
                block.c(world, pos.x, pos.y, pos.z, metadata, this.getFortuneLevel(this.axe));
                if (!(!TCSettings.allowItemDamage || this.player.ce.d || this.axe == null || this.axe.a <= 0 || this.vineID.equals((Object)new BlockID(block, metadata)) || this.isLeafBlock(new BlockID(block, metadata)) || pos.equals((Object)this.startPos))) {
                    if (!this.damageAxeAndContinue(world, id, this.startPos.x, this.startPos.y, this.startPos.z)) {
                        list.clear();
                    }
                    ++this.numLogsBroken;
                    if (TCSettings.useIncreasingItemDamage && this.numLogsBroken % TCSettings.increaseDamageEveryXBlocks == 0) {
                        this.logDamageMultiplier += TCSettings.damageIncreaseAmount;
                    }
                }
            }
            if (world.d(pos.x, pos.y, pos.z)) {
                world.s(pos.x, pos.y, pos.z);
            }
            world.f(pos.x, pos.y, pos.z, 0, 0, 3);
        }
    }

    private boolean damageAxeAndContinue(aab world, int id, int x, int y, int z) {
        if (this.axe != null) {
            this.currentAxeDamage += this.logDamageMultiplier;
            for (int i = 0; i < (int)Math.floor(this.currentAxeDamage); ++i) {
                this.axe.b().a(this.axe, world, id, x, y, z, (ng)this.player);
            }
            this.currentAxeDamage = (float)((double)this.currentAxeDamage - Math.floor(this.currentAxeDamage));
            if (this.axe != null && this.axe.a < 1) {
                this.player.ce();
            }
        }
        return !TCSettings.needItem || TCSettings.allowMoreBlocksThanDamage || this.isAxeItemEquipped();
    }

    private boolean damageShearsAndContinue(aab world, int id, int x, int y, int z) {
        if (this.shears != null) {
            int shearsIndex = this.shearsHotbarIndex(this.player);
            this.currentShearsDamage += this.leafDamageMultiplier;
            int i = 0;
            while ((double)i < Math.floor(this.currentShearsDamage)) {
                if (TCSettings.isForge && this.shears.c == wk.bf.cp) {
                    this.shears.a(1, (ng)this.player);
                } else {
                    this.shears.b().a(this.shears, world, id, x, y, z, (ng)this.player);
                }
                ++i;
            }
            this.currentShearsDamage = (float)((double)this.currentShearsDamage - Math.floor(this.currentShearsDamage));
            if (this.shears != null && this.shears.a < 1 && shearsIndex != -1) {
                this.player.bK.a(shearsIndex, (wm)null);
            }
        }
        return TCSettings.allowMoreBlocksThanDamage || this.hasShearsInHotbar(this.player);
    }

    private List addLogs(aab world, Coord pos) {
        int index = 0;
        int lowY = pos.y;
        ArrayList<Coord> list = new ArrayList<Coord>();
        list.add(pos);
        do {
            Coord currentLog = (Coord)list.get(index);
            for (int x = -1; x <= 1; ++x) {
                int y;
                int n = y = this.treeDef.onlyDestroyUpwards() ? 0 : -1;
                while (y <= 1) {
                    for (int z = -1; z <= 1; ++z) {
                        if (!this.treeDef.logBlocks.contains(new BlockID(world, currentLog.x + x, currentLog.y + y, currentLog.z + z))) continue;
                        Coord newPos = new Coord(currentLog.x + x, currentLog.y + y, currentLog.z + z);
                        if (this.treeDef.maxHorLogBreakDist() != -1 && (Math.abs(newPos.x - this.startPos.x) > this.treeDef.maxHorLogBreakDist() || Math.abs(newPos.z - this.startPos.z) > this.treeDef.maxHorLogBreakDist() || this.treeDef.maxVerLogBreakDist() != -1 && Math.abs(newPos.y - this.startPos.y) > this.treeDef.maxVerLogBreakDist() || list.contains(newPos) || newPos.y < lowY && this.treeDef.onlyDestroyUpwards())) continue;
                        list.add(newPos);
                    }
                    ++y;
                }
            }
        } while (++index < list.size());
        return list;
    }

    private void addLogsAbove(aab world, Coord position, List listFinal) {
        ArrayList<Coord> listAbove = new ArrayList<Coord>();
        listAbove.add(position);
        do {
            Coord newPosition;
            int z;
            int x;
            ArrayList<Coord> list = listAbove;
            listAbove = new ArrayList();
            for (Coord pos : list) {
                int counter = 0;
                for (x = -1; x <= 1; ++x) {
                    for (z = -1; z <= 1; ++z) {
                        if (!this.treeDef.logBlocks.contains(new BlockID(world, pos.x + x, pos.y + 1, pos.z + z))) continue;
                        newPosition = new Coord(pos.x + x, pos.y + 1, pos.z + z);
                        if (!listAbove.contains(newPosition)) {
                            listAbove.add(newPosition);
                        }
                        ++counter;
                    }
                }
                if (counter != 0) continue;
                listFinal.add(pos.clone());
            }
            int index = -1;
            while (++index < listAbove.size()) {
                Coord pos = (Coord)listAbove.get(index);
                for (x = -1; x <= 1; ++x) {
                    for (z = -1; z <= 1; ++z) {
                        if (!this.treeDef.logBlocks.contains(new BlockID(world, pos.x + x, pos.y, pos.z + z)) || listAbove.contains(newPosition = new Coord(pos.x + x, pos.y, pos.z + z))) continue;
                        listAbove.add(newPosition);
                    }
                }
            }
        } while (listAbove.size() > 0);
    }

    public List addLeaves(aab world, Coord pos, List list) {
        int index = -1;
        if (list == null) {
            list = new ArrayList();
        }
        this.addLeavesInDistance(world, pos, this.treeDef.maxHorLeafBreakDist(), list);
        while (++index < list.size()) {
            Coord pos2 = (Coord)list.get(index);
            if (CommonUtils.getHorSquaredDistance((Coord)pos, (Coord)pos2) >= this.treeDef.maxHorLeafBreakDist()) continue;
            this.addLeavesInDistance(world, pos2, 1, list);
        }
        return list;
    }

    public void addLeavesInDistance(aab world, Coord pos, int range, List list) {
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    Coord newPos;
                    int md;
                    int blockID = world.a(x + pos.x, y + pos.y, z + pos.z);
                    if (!this.isLeafBlock(new BlockID(blockID, md = world.h(x + pos.x, y + pos.y, z + pos.z))) && !this.vineID.equals((Object)new BlockID(blockID))) continue;
                    int metadata = world.h(x + pos.x, y + pos.y, z + pos.z);
                    if (this.treeDef.requireLeafDecayCheck() && ((metadata & 8) == 0 || (metadata & 4) != 0) || list.contains(newPos = new Coord(x + pos.x, y + pos.y, z + pos.z)) || this.hasLogClose(world, newPos, 1)) continue;
                    list.add(newPos);
                }
            }
        }
    }

    protected void addConnectedLeavesInRange(aab world, Coord pos, int range, int distance, List list) {
        if (!list.contains(pos)) {
            int blockID = world.a(pos.x, pos.y, pos.z);
            int md = world.h(pos.x, pos.y, pos.z);
            if (Math.abs(distance) <= range && (this.isLeafBlock(new BlockID(blockID, md)) || this.vineID.equals((Object)new BlockID(blockID)) || distance == 0)) {
                if ((!this.treeDef.requireLeafDecayCheck() || (md & 8) != 0 && (md & 4) == 0) && distance != 0) {
                    list.add(pos);
                }
                for (int x = -1; x <= 1; ++x) {
                    for (int y = -1; y <= 1; ++y) {
                        for (int z = -1; z <= 1; ++z) {
                            this.addConnectedLeavesInRange(world, new Coord(pos.x + x, pos.y + y, pos.z + z), range, distance + 1, list);
                        }
                    }
                }
            }
        }
    }

    public boolean hasLogClose(aab world, Coord pos, int i) {
        for (int x = -i; x <= i; ++x) {
            for (int y = -i; y <= i; ++y) {
                for (int z = -i; z <= i; ++z) {
                    Coord neighbor = new Coord(x + pos.x, y + pos.y, z + pos.z);
                    int neighborID = world.a(neighbor.x, neighbor.y, neighbor.z);
                    if (x == 0 && y == 0 && z == 0 || neighborID == 0 || !this.masterLogList.contains(new BlockID(world, neighbor.x, neighbor.y, neighbor.z)) || neighbor.equals((Object)this.startPos)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

