/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.treecapitator;

import bspkrs.util.ItemID;
import bspkrs.util.ListUtils;
import java.util.ArrayList;
import java.util.List;

public class ToolRegistry {
    private static ToolRegistry instance;
    private List axeList;
    private List shearsList;
    private List vanAxeList;
    private List vanShearsList;

    public static ToolRegistry instance() {
        if (instance == null) {
            new ToolRegistry();
        }
        return instance;
    }

    protected ToolRegistry() {
        instance = this;
        this.initLists();
        this.initVanillaItemLists();
    }

    protected void initLists() {
        this.axeList = new ArrayList();
        this.shearsList = new ArrayList();
    }

    protected void initVanillaLists() {
        this.vanAxeList = new ArrayList();
        this.vanShearsList = new ArrayList();
    }

    protected void initVanillaItemLists() {
        this.initVanillaLists();
        this.vanAxeList.add(new ItemID(wk.v));
        this.vanAxeList.add(new ItemID(wk.z));
        this.vanAxeList.add(new ItemID(wk.i));
        this.vanAxeList.add(new ItemID(wk.K));
        this.vanAxeList.add(new ItemID(wk.D));
        this.vanShearsList.add(new ItemID((wk)wk.bf));
    }

    protected void readFromNBT(bs ntc) {
        this.axeList = ListUtils.getDelimitedStringAsItemIDList((String)ntc.i("axeIDList"), (String)";");
        this.shearsList = ListUtils.getDelimitedStringAsItemIDList((String)ntc.i("shearsIDList"), (String)";");
    }

    public void writeToNBT(bs ntc) {
        ntc.a("axeIDList", ListUtils.getListAsDelimitedString((List)this.axeList, (String)";"));
        ntc.a("shearsIDList", ListUtils.getListAsDelimitedString((List)this.shearsList, (String)";"));
    }

    public void registerAxe(ItemID axe) {
        if (axe != null && !this.axeList.contains(axe)) {
            this.axeList.add(axe);
        }
    }

    public void registerShears(ItemID shears) {
        if (shears != null && !this.shearsList.contains(shears)) {
            this.shearsList.add(shears);
        }
    }

    public List axeList() {
        return new ArrayList(this.axeList);
    }

    public List shearsList() {
        return new ArrayList(this.shearsList);
    }

    public List vanillaAxeList() {
        return new ArrayList(this.vanAxeList);
    }

    public List vanillaShearsList() {
        return new ArrayList(this.vanShearsList);
    }

    public boolean isAxe(ItemID itemID) {
        return this.axeList.contains(itemID);
    }

    public boolean isAxe(wk item) {
        if (item != null) {
            return this.axeList.contains(new ItemID(item));
        }
        return false;
    }

    public boolean isAxe(wm itemStack) {
        if (itemStack != null) {
            return this.axeList.contains(new ItemID(itemStack));
        }
        return false;
    }

    public boolean isShears(ItemID itemID) {
        return this.shearsList.contains(itemID);
    }

    public boolean isShears(wk item) {
        if (item != null) {
            return this.shearsList.contains(new ItemID(item));
        }
        return false;
    }

    public boolean isShears(wm itemStack) {
        if (itemStack != null) {
            return this.shearsList.contains(new ItemID(itemStack));
        }
        return false;
    }
}

