/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.treecapitator;

import bspkrs.treecapitator.BlockTree;
import bspkrs.treecapitator.EnchantmentTreecapitating;
import bspkrs.treecapitator.TCLog;
import bspkrs.treecapitator.ToolRegistry;
import bspkrs.treecapitator.TreeRegistry;
import bspkrs.util.Configuration;
import bspkrs.util.ListUtils;
import java.util.List;
import java.util.logging.Level;

public final class TCSettings {
    public static boolean allowDebugLogging = false;
    public static boolean allowDebugOutput = false;
    public static boolean allowItemDamage = true;
    public static boolean allowMoreBlocksThanDamage = false;
    public static float damageIncreaseAmount = 1.0f;
    public static float damageMultiplier = 1.0f;
    public static boolean destroyLeaves = true;
    public static boolean disableCreativeDrops = false;
    public static boolean disableInCreative = false;
    public static boolean enableEnchantmentMode = false;
    public static int enchantmentID = 187;
    private static final int enchantmentWeight = 5;
    public static int increaseDamageEveryXBlocks = 8;
    public static boolean needItem = true;
    public static boolean requireItemInAxeListForEnchant = true;
    public static boolean shearLeaves = false;
    public static boolean shearVines = false;
    public static String sneakAction = "disable";
    public static boolean useIncreasingItemDamage = false;
    public static boolean useStrictBlockPairing = true;
    public static boolean allowSmartTreeDetection = true;
    public static float breakSpeedModifier = 0.256f;
    public static int maxHorLogBreakDist = 16;
    public static int maxHorLeafBreakDist = 4;
    public static int maxLeafIDDist = 1;
    public static int maxVerLogBreakDist = -1;
    public static int minLeavesToID = 3;
    public static boolean onlyDestroyUpwards = true;
    public static boolean requireLeafDecayCheck = true;
    public static String idResolverModID = "IDResolver";
    public static String multiMineModID = "AS_MultiMine";
    public static boolean userConfigOverridesIMC = false;
    public static boolean treeHeightDecidesBreakSpeed = true;
    public static float logHardnessModified = 4.0f;
    public static float logHardnessNormal = 2.0f;
    public static String axeIDList = ListUtils.getListAsDelimitedString((List)ToolRegistry.instance().vanillaAxeList(), (String)"; ");
    public static String shearIDList = ListUtils.getListAsDelimitedString((List)ToolRegistry.instance().vanillaShearsList(), (String)"; ");
    public static apa wood;
    public static yz treecapitating;
    public static boolean isForge;
    private static TCSettings instance;

    public static TCSettings instance() {
        if (instance == null) {
            new TCSettings();
        }
        return instance;
    }

    public static void preInit() {
        TCSettings.preInit(false);
    }

    public static void preInit(boolean isForgeVersion) {
        isForge = isForgeVersion;
        if (!isForge) {
            apa.r[apa.N.cz] = null;
            apa.r[TCSettings.wood.cz] = wood = new BlockTree(apa.N.cz);
            wk.f[TCSettings.wood.cz] = null;
            wk.f[TCSettings.wood.cz] = new wt(TCSettings.wood.cz - 256, wood, apk.a).b("log");
            TreeRegistry.instance().registerVanillaTreeDefs();
        }
    }

    private TCSettings() {
        instance = this;
    }

    public void handleEnchantmentID(int id) {
        if (id >= 0 && id < 256 && enableEnchantmentMode) {
            if (yz.b[enchantmentID] != null) {
                yz.b[TCSettings.enchantmentID] = null;
            }
            enchantmentID = id;
            treecapitating = new EnchantmentTreecapitating(enchantmentID, 5);
            treecapitating.b("treecapitating");
            ModLoader.addLocalization((String)"enchantment.treecapitating", (String)"Treecapitating");
        }
    }

    protected void readFromNBT(bs ntc) {
        allowItemDamage = ntc.n("allowItemDamage");
        allowMoreBlocksThanDamage = ntc.n("allowMoreBlocksThanDamage");
        allowSmartTreeDetection = ntc.n("allowSmartTreeDetection");
        treeHeightDecidesBreakSpeed = ntc.n("treeHeightDecidesBreakSpeed");
        breakSpeedModifier = ntc.g("breakSpeedModifier");
        damageIncreaseAmount = ntc.g("damageIncreaseAmount");
        damageMultiplier = ntc.g("damageMultiplier");
        destroyLeaves = ntc.n("destroyLeaves");
        disableCreativeDrops = ntc.n("disableCreativeDrops");
        disableInCreative = ntc.n("disableInCreative");
        enableEnchantmentMode = ntc.n("enableEnchantmentMode");
        this.handleEnchantmentID(ntc.e("enchantmentID"));
        increaseDamageEveryXBlocks = ntc.e("increaseDamageEveryXBlocks");
        maxHorLogBreakDist = ntc.e("maxHorLogBreakDist");
        maxHorLeafBreakDist = ntc.e("maxHorLeafBreakDist");
        maxLeafIDDist = ntc.e("maxLeafIDDist");
        maxVerLogBreakDist = ntc.e("maxVerLogBreakDist");
        minLeavesToID = ntc.e("minLeavesToID");
        needItem = ntc.n("needItem");
        onlyDestroyUpwards = ntc.n("onlyDestroyUpwards");
        requireItemInAxeListForEnchant = ntc.n("requireItemInAxeListForEnchant");
        requireLeafDecayCheck = ntc.n("requireLeafDecayCheck");
        shearLeaves = ntc.n("shearLeaves");
        shearVines = ntc.n("shearVines");
        sneakAction = ntc.i("sneakAction");
        useIncreasingItemDamage = ntc.n("useIncreasingItemDamage");
        useStrictBlockPairing = ntc.n("useStrictBlockPairing");
    }

    public void writeToNBT(bs ntc) {
        ntc.a("allowItemDamage", allowItemDamage);
        ntc.a("allowMoreBlocksThanDamage", allowMoreBlocksThanDamage);
        ntc.a("allowSmartTreeDetection", allowSmartTreeDetection);
        ntc.a("treeHeightDecidesBreakSpeed", treeHeightDecidesBreakSpeed);
        ntc.a("breakSpeedModifier", breakSpeedModifier);
        ntc.a("damageIncreaseAmount", damageIncreaseAmount);
        ntc.a("damageMultiplier", damageMultiplier);
        ntc.a("destroyLeaves", destroyLeaves);
        ntc.a("disableCreativeDrops", disableCreativeDrops);
        ntc.a("disableInCreative", disableInCreative);
        ntc.a("enableEnchantmentMode", enableEnchantmentMode);
        ntc.a("enchantmentID", enchantmentID);
        ntc.a("increaseDamageEveryXBlocks", increaseDamageEveryXBlocks);
        ntc.a("maxHorLogBreakDist", maxHorLogBreakDist);
        ntc.a("maxHorLeafBreakDist", maxHorLeafBreakDist);
        ntc.a("maxLeafIDDist", maxLeafIDDist);
        ntc.a("maxVerLogBreakDist", maxVerLogBreakDist);
        ntc.a("minLeavesToID", minLeavesToID);
        ntc.a("needItem", needItem);
        ntc.a("onlyDestroyUpwards", onlyDestroyUpwards);
        ntc.a("requireItemInAxeListForEnchant", requireItemInAxeListForEnchant);
        ntc.a("requireLeafDecayCheck", requireLeafDecayCheck);
        ntc.a("shearLeaves", shearLeaves);
        ntc.a("shearVines", shearVines);
        ntc.a("sneakAction", sneakAction);
        ntc.a("useIncreasingItemDamage", useIncreasingItemDamage);
        ntc.a("useStrictBlockPairing", useStrictBlockPairing);
    }

    public void syncConfiguration(Configuration config) {
        allowDebugLogging = config.getBoolean("allowDebugLogging", "general_settings.global_settings", allowDebugLogging, "[Global] Set to true if you want TreeCapitator to log info about what it's doing, false to disable.\nIf you are having an issue with the mod, set this option to true and post the resulting log to the\nTreeCapitator Minecraftforum.net thread along with a detailed description of the issue.");
        allowDebugOutput = config.getBoolean("allowDebugOutput", "general_settings.global_settings", allowDebugOutput, "[Global] Set to true if you want TreeCapitator to tell you what kind of block you have clicked when \nsneaking, false to disable.");
        allowItemDamage = config.getBoolean("allowItemDamage", "general_settings.global_settings", allowItemDamage, "[Global] Enable to cause item damage based on number of blocks destroyed");
        allowMoreBlocksThanDamage = config.getBoolean("allowMoreBlocksThanDamage", "general_settings.global_settings", allowMoreBlocksThanDamage, "[Global] Enable to allow chopping down the entire tree even if your item does not have enough damage \nremaining to cover the number of blocks.");
        damageIncreaseAmount = config.getFloat("damageIncreaseAmount", "general_settings.global_settings", damageIncreaseAmount, 0.1f, 100.0f, "[Global] When useIncreasingItemDamage=true the damage applied per block broken will increase by this \namount every increaseDamageEveryXBlocks blocks broken in a tree.");
        damageMultiplier = config.getFloat("damageMultiplier", "general_settings.global_settings", damageMultiplier, 0.1f, 50.0f, "[Global] Axes and shears will take damage this many times for each log broken. Remaining damage is \nrounded and applied to tools when a tree is finished.");
        destroyLeaves = config.getBoolean("destroyLeaves", "general_settings.global_settings", destroyLeaves, "[Global] Enabling this will make leaves be destroyed when trees are chopped.");
        disableCreativeDrops = config.getBoolean("disableCreativeDrops", "general_settings.global_settings", disableCreativeDrops, "[Global] Flag to disable drops in Creative mode");
        disableInCreative = config.getBoolean("disableInCreative", "general_settings.global_settings", disableInCreative, "[Global] Flag to disable tree chopping in Creative mode");
        enableEnchantmentMode = config.getBoolean("enableEnchantmentMode", "general_settings.global_settings", enableEnchantmentMode, "[Global] Toggle for whether or not to use the Treecapitating enchantment as opposed to requiring an item \nto be in the axeIDList to chop a tree.");
        this.handleEnchantmentID(config.getInt("enchantmentID", "general_settings.global_settings", enchantmentID, 0, yz.b.length - 1, "[Global] The internal ID for the Treecapitating enchantment. Change this if the default ID is conflicting \nwith another mod."));
        increaseDamageEveryXBlocks = config.getInt("increaseDamageEveryXBlocks", "general_settings.global_settings", increaseDamageEveryXBlocks, 1, 500, "[Global] When useIncreasingItemDamage=true the damage applied per block broken will increase each time \nthis many blocks are broken in a tree.");
        needItem = config.getBoolean("needItem", "general_settings.global_settings", needItem, "[Global] Whether you need an item from the axeIDList to chop down a tree. Disabling will let you chop \ntrees with any item.");
        requireItemInAxeListForEnchant = config.getBoolean("requireItemInAxeListForEnchant", "general_settings.global_settings", requireItemInAxeListForEnchant, "[Global] Whether or not to check the axe ID list for an item when determining if a given item can be \nimbued with the Treecapitating enchantment.\nNOTE: when set to false, any ItemTool type item (pickaxes, shovels, etc) with a high enough \nenchantability level can get the enchantment, not just axes.");
        shearLeaves = config.getBoolean("shearLeaves", "general_settings.global_settings", shearLeaves, "[Global] Enabling this will cause destroyed leaves to be sheared when a shearing item is in the hotbar \n(ignored if destroyLeaves is false).");
        shearVines = config.getBoolean("shearVines", "general_settings.global_settings", shearVines, "[Global] Enabling this will shear /some/ of the vines on a tree when a shearing item is in the hotbar \n(ignored if destroyLeaves is false).");
        sneakAction = config.getString("sneakAction", "general_settings.global_settings", sneakAction, "[Global] Set sneakAction = \"disable\" to disable tree chopping while sneaking,\nset sneakAction = \"enable\" to only enable tree chopping while sneaking,\nset sneakAction = \"none\" to have tree chopping enabled regardless of sneaking.");
        useIncreasingItemDamage = config.getBoolean("useIncreasingItemDamage", "general_settings.global_settings", useIncreasingItemDamage, "[Global] Set to true to have the per-block item damage amount increase after every \nincreaseDamageEveryXBlocks blocks are broken.");
        useStrictBlockPairing = config.getBoolean("useStrictBlockPairing", "general_settings.global_settings", useStrictBlockPairing, "[Global] Set to true if you want only the log/leaf blocks listed with each log in a tree\nto break when that log type is chopped.  When set to false it will break\nany log/leaf type blocks connected to the tree, not just the types for that tree.");
        treeHeightDecidesBreakSpeed = config.getBoolean("treeHeightDecidesBreakSpeed", "general_settings.global_settings", treeHeightDecidesBreakSpeed, "[Global] When true, the log break speed is equal to original break speed / (tree height * 2)\nWhen false, the original break speed is multiplied by the breakSpeedModifier value");
        config.addCustomCategoryComment("general_settings.global_settings", "These are the general preference settings. They are used globally to tune how TreeCapitator works.");
        allowSmartTreeDetection = config.getBoolean("allowSmartTreeDetection", "general_settings.per_tree_defaults", allowSmartTreeDetection, "[Global] Set to false to disable TreeCapitator Smart Tree Detection.\nSmart Tree Detection counts the number of leaf blocks that are adjacent to the\ntop-most connected log block at the x, z location of a log you've broken. If\nthere are at least minLeavesToID leaf blocks within maxLeafIDDist blocks then\nTreeCapitator considers it a tree and allows chopping.\nWARNING: Disabling Smart Tree Detection will remove the only safeguard against\naccidentally destroying a log structure.  Make sure you know what you're doing!");
        breakSpeedModifier = config.getFloat("breakSpeedModifier", "general_settings.per_tree_defaults", breakSpeedModifier, 0.01f, 1.0f, "[Global, PerTree] When using an item that can chop trees, the break speed will by multiplied by this value\nTHIS OPTION IS IGNORED WHEN treeHeightDecidesBreakSpeed=true");
        maxHorLeafBreakDist = config.getInt("maxHorLeafBreakDist", "general_settings.per_tree_defaults", maxHorLeafBreakDist, -1, 100, "[Global, PerTree] The maximum horizontal distance that the leaf breaking effect will travel from the tree (use -1 for no limit).");
        maxHorLogBreakDist = config.getInt("maxHorLogBreakDist", "general_settings.per_tree_defaults", maxHorLogBreakDist, -1, 100, "[Global, PerTree] The maximum horizontal distance that the log breaking effect will travel (use -1 for no limit).");
        maxVerLogBreakDist = config.getInt("maxVerLogBreakDist", "general_settings.per_tree_defaults", maxVerLogBreakDist, -1, 255, "[Global, PerTree] The maximum vertical distance that the log breaking effect will travel (use -1 for no limit).");
        maxLeafIDDist = config.getInt("maxLeafIDDist", "general_settings.per_tree_defaults", maxLeafIDDist, 1, 8, "[Global, PerTree] If a tree's top log is not close enough to leaf blocks, the tree will not be chopped.\nIncreasing this value will search further.  I would try to keep it at or below 3.");
        minLeavesToID = config.getInt("minLeavesToID", "general_settings.per_tree_defaults", minLeavesToID, 0, 8, "[Global, PerTree] The minimum number of leaves within maxLeafIDDist of the top log block required to identify a tree.");
        onlyDestroyUpwards = config.getBoolean("onlyDestroyUpwards", "general_settings.per_tree_defaults", onlyDestroyUpwards, "[Global, PerTree] Setting this to false will allow the chopping to move downward as well as upward (and \nblocks below the one you break will be chopped)");
        requireLeafDecayCheck = config.getBoolean("requireLeafDecayCheck", "general_settings.per_tree_defaults", requireLeafDecayCheck, "[Global, PerTree] When true TreeCapitator will only instantly decay leaves that have actually been marked \nfor decay. Set to false if you want leaves to be destroyed regardless of their decay status \n(hint: or for \"leaf\" blocks that are not really leaves).");
        config.addCustomCategoryComment("general_settings.per_tree_defaults", "These are the default values of settings that can be defined on a per-tree basis. If a \nuser-/mod-defined tree sets one of these values it will override the default value here.");
        Level level = TCLog.INSTANCE.getLogger().getLevel();
        if (allowDebugLogging) {
            TCLog.INSTANCE.getLogger().setLevel(Level.CONFIG);
        }
        TCLog.configs(config, "general_settings.global_settings");
        TCLog.configs(config, "general_settings.per_tree_defaults");
        if (allowDebugLogging) {
            TCLog.INSTANCE.getLogger().setLevel(level);
        }
    }

    static {
        isForge = false;
    }
}

