/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.treecapitator;

import bspkrs.treecapitator.TCSettings;
import bspkrs.treecapitator.ToolRegistry;
import bspkrs.treecapitator.TreeRegistry;

public class RegistryNBTManager {
    private bs localTCSettings;
    private bs localTreeRegistry;
    private bs localToolRegistry;
    private bs remoteTCSettings;
    private bs remoteTreeRegistry;
    private bs remoteToolRegistry;

    public RegistryNBTManager(bs tcSettingsNBT, bs treeRegistryNBT, bs toolRegistryNBT) {
        this();
        this.setRemoteTCSettings(tcSettingsNBT);
        this.setRemoteTreeRegistry(treeRegistryNBT);
        this.setRemoteToolRegistry(toolRegistryNBT);
    }

    public RegistryNBTManager() {
        this.saveCurrentTCSettingsToLocal();
        this.saveCurrentTreeRegistryToLocal();
        this.saveCurrentToolRegistryToLocal();
        this.setRemoteTCSettings(this.localTCSettings);
        this.setRemoteTreeRegistry(this.localTreeRegistry);
        this.setRemoteToolRegistry(this.localToolRegistry);
    }

    protected RegistryNBTManager saveCurrentTCSettingsToLocal() {
        this.localTCSettings = new bs();
        TCSettings.instance().writeToNBT(this.localTCSettings);
        return this;
    }

    protected RegistryNBTManager saveCurrentTreeRegistryToLocal() {
        this.localTreeRegistry = new bs();
        TreeRegistry.instance().writeToNBT(this.localTreeRegistry);
        return this;
    }

    protected RegistryNBTManager saveCurrentToolRegistryToLocal() {
        this.localToolRegistry = new bs();
        ToolRegistry.instance().writeToNBT(this.localToolRegistry);
        return this;
    }

    public RegistryNBTManager setRemoteTCSettings(bs ntc) {
        this.remoteTCSettings = ntc;
        return this;
    }

    public RegistryNBTManager setRemoteTreeRegistry(bs ntc) {
        this.remoteTreeRegistry = ntc;
        return this;
    }

    public RegistryNBTManager setRemoteToolRegistry(bs ntc) {
        this.remoteToolRegistry = ntc;
        return this;
    }

    public RegistryNBTManager setRemoteNBTs(bs set, bs tree, bs tool) {
        return this.setRemoteTCSettings(set).setRemoteTreeRegistry(tree).setRemoteToolRegistry(tool);
    }

    public void registerLocalInstances() {
        TCSettings.instance().readFromNBT(this.localTCSettings);
        TreeRegistry.instance().readFromNBT(this.localTreeRegistry);
        ToolRegistry.instance().readFromNBT(this.localToolRegistry);
    }

    public void registerRemoteInstances() {
        TCSettings.instance().readFromNBT(this.remoteTCSettings);
        TreeRegistry.instance().readFromNBT(this.remoteTreeRegistry);
        ToolRegistry.instance().readFromNBT(this.remoteToolRegistry);
    }

    public Object[] getPacketArray() {
        return new Object[]{this.localTCSettings, this.localTreeRegistry, this.localToolRegistry};
    }
}

