/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraftforge.event.Cancelable;
import net.minecraftforge.event.ListenerList;

public class Event {
    private boolean isCanceled = false;
    private final boolean isCancelable;
    private Result result = Result.DEFAULT;
    private final boolean hasResult;
    private static ListenerList listeners = new ListenerList();
    private static final Map<Class, Map<Class, Boolean>> annotationMap = new ConcurrentHashMap<Class, Map<Class, Boolean>>();

    public Event() {
        this.setup();
        this.isCancelable = this.hasAnnotation(Cancelable.class);
        this.hasResult = this.hasAnnotation(HasResult.class);
    }

    private boolean hasAnnotation(Class annotation) {
        Boolean cached;
        Class<?> me2 = this.getClass();
        Map<Class, Boolean> list = annotationMap.get(me2);
        if (list == null) {
            list = new ConcurrentHashMap<Class, Boolean>();
            annotationMap.put(me2, list);
        }
        if ((cached = list.get(annotation)) != null) {
            return cached;
        }
        for (Class<?> cls = me2; cls != Event.class; cls = cls.getSuperclass()) {
            if (!cls.isAnnotationPresent(annotation)) continue;
            list.put(annotation, true);
            return true;
        }
        list.put(annotation, false);
        return false;
    }

    public boolean isCancelable() {
        return this.isCancelable;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setCanceled(boolean cancel) {
        if (!this.isCancelable()) {
            throw new IllegalArgumentException("Attempted to cancel a uncancelable event");
        }
        this.isCanceled = cancel;
    }

    public boolean hasResult() {
        return this.hasResult;
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result value) {
        this.result = value;
    }

    protected void setup() {
    }

    public ListenerList getListenerList() {
        return listeners;
    }

    public static enum Result {
        DENY,
        DEFAULT,
        ALLOW;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface HasResult {
    }
}

