/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.network.FMLNetworkHandler;
import cpw.mods.fml.common.network.FMLPacket;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.common.versioning.VersionRange;
import java.util.List;

public class ModMissingPacket
extends FMLPacket {
    private List<ModData> missing;
    private List<ModData> badVersion;

    public ModMissingPacket() {
        super(FMLPacket.Type.MOD_MISSING);
    }

    @Override
    public byte[] generatePacket(Object ... data) {
        ModContainer mc2;
        ByteArrayDataOutput dat = ByteStreams.newDataOutput();
        List missing = (List)data[0];
        List badVersion = (List)data[1];
        dat.writeInt(missing.size());
        for (String missed : missing) {
            mc2 = Loader.instance().getIndexedModList().get(missed);
            dat.writeUTF(missed);
            dat.writeUTF(mc2.getVersion());
        }
        dat.writeInt(badVersion.size());
        for (String bad2 : badVersion) {
            mc2 = Loader.instance().getIndexedModList().get(bad2);
            dat.writeUTF(bad2);
            dat.writeUTF(mc2.getVersion());
        }
        return dat.toByteArray();
    }

    @Override
    public FMLPacket consumePacket(byte[] data) {
        ByteArrayDataInput dat = ByteStreams.newDataInput((byte[])data);
        int missingLen = dat.readInt();
        this.missing = Lists.newArrayListWithCapacity((int)missingLen);
        for (int i2 = 0; i2 < missingLen; ++i2) {
            ModData md2 = new ModData();
            md2.modId = dat.readUTF();
            md2.modVersion = dat.readUTF();
            this.missing.add(md2);
        }
        int badVerLength = dat.readInt();
        this.badVersion = Lists.newArrayListWithCapacity((int)badVerLength);
        for (int i3 = 0; i3 < badVerLength; ++i3) {
            ModData md3 = new ModData();
            md3.modId = dat.readUTF();
            md3.modVersion = dat.readUTF();
            this.badVersion.add(md3);
        }
        return this;
    }

    @Override
    public void execute(cg network, FMLNetworkHandler handler, ej netHandler, String userName) {
        FMLCommonHandler.instance().getSidedDelegate().displayMissingMods(this);
    }

    public List<ArtifactVersion> getModList() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ModData md2 : this.missing) {
            builder.add((Object)new DefaultArtifactVersion(md2.modId, VersionRange.createFromVersion(md2.modVersion, null)));
        }
        for (ModData md2 : this.badVersion) {
            builder.add((Object)new DefaultArtifactVersion(md2.modId, VersionRange.createFromVersion(md2.modVersion, null)));
        }
        return builder.build();
    }

    private static class ModData {
        String modId;
        String modVersion;

        private ModData() {
        }
    }
}

