/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network;

import com.google.common.base.Throwables;
import com.google.common.collect.MapMaker;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import com.google.common.primitives.UnsignedBytes;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.EntitySpawnAdjustmentPacket;
import cpw.mods.fml.common.network.EntitySpawnPacket;
import cpw.mods.fml.common.network.FMLNetworkException;
import cpw.mods.fml.common.network.FMLNetworkHandler;
import cpw.mods.fml.common.network.ModIdMapPacket;
import cpw.mods.fml.common.network.ModIdentifiersPacket;
import cpw.mods.fml.common.network.ModListRequestPacket;
import cpw.mods.fml.common.network.ModListResponsePacket;
import cpw.mods.fml.common.network.ModMissingPacket;
import cpw.mods.fml.common.network.OpenGuiPacket;
import java.util.Arrays;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;

public abstract class FMLPacket {
    private Type type;

    public static byte[][] makePacketSet(Type type, Object ... data) {
        if (!type.isMultipart()) {
            return new byte[0][];
        }
        byte[] packetData = type.make().generatePacket(data);
        byte[][] chunks = new byte[packetData.length / 32000 + 1][];
        for (int i2 = 0; i2 < packetData.length / 32000 + 1; ++i2) {
            int len = Math.min(32000, packetData.length - i2 * 32000);
            chunks[i2] = Bytes.concat((byte[][])new byte[][]{{UnsignedBytes.checkedCast((long)type.ordinal()), UnsignedBytes.checkedCast((long)i2), UnsignedBytes.checkedCast((long)chunks.length)}, Ints.toByteArray((int)len), Arrays.copyOfRange(packetData, i2 * 32000, len + i2 * 32000)});
        }
        return chunks;
    }

    public static byte[] makePacket(Type type, Object ... data) {
        byte[] packetData = type.make().generatePacket(data);
        return Bytes.concat((byte[][])new byte[][]{{UnsignedBytes.checkedCast((long)type.ordinal())}, packetData});
    }

    public static FMLPacket readPacket(cg network, byte[] payload) {
        int type = UnsignedBytes.toInt((byte)payload[0]);
        Type eType = Type.values()[type];
        FMLPacket pkt = eType.isMultipart() ? eType.findCurrentPart(network) : eType.make();
        return pkt.consumePacket(Arrays.copyOfRange(payload, 1, payload.length));
    }

    public FMLPacket(Type type) {
        this.type = type;
    }

    public abstract byte[] generatePacket(Object ... var1);

    public abstract FMLPacket consumePacket(byte[] var1);

    public abstract void execute(cg var1, FMLNetworkHandler var2, ej var3, String var4);

    static enum Type {
        MOD_LIST_REQUEST(ModListRequestPacket.class, false),
        MOD_LIST_RESPONSE(ModListResponsePacket.class, false),
        MOD_IDENTIFIERS(ModIdentifiersPacket.class, false),
        MOD_MISSING(ModMissingPacket.class, false),
        GUIOPEN(OpenGuiPacket.class, false),
        ENTITYSPAWN(EntitySpawnPacket.class, false),
        ENTITYSPAWNADJUSTMENT(EntitySpawnAdjustmentPacket.class, false),
        MOD_IDMAP(ModIdMapPacket.class, true);

        private Class<? extends FMLPacket> packetType;
        private boolean isMultipart;
        private ConcurrentMap<cg, FMLPacket> partTracker;

        private Type(Class<? extends FMLPacket> clazz, boolean isMultipart) {
            this.packetType = clazz;
            this.isMultipart = isMultipart;
        }

        FMLPacket make() {
            try {
                return this.packetType.newInstance();
            }
            catch (Exception e2) {
                Throwables.propagateIfPossible((Throwable)e2);
                FMLLog.log(Level.SEVERE, e2, "A bizarre critical error occured during packet encoding", new Object[0]);
                throw new FMLNetworkException(e2);
            }
        }

        public boolean isMultipart() {
            return this.isMultipart;
        }

        private FMLPacket findCurrentPart(cg network) {
            if (this.partTracker == null) {
                this.partTracker = new MapMaker().weakKeys().weakValues().makeMap();
            }
            if (!this.partTracker.containsKey(network)) {
                this.partTracker.put(network, this.make());
            }
            return (FMLPacket)this.partTracker.get(network);
        }
    }
}

