/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.thaumcraft;

import codechicken.nei.PositionedStack;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import mods.neiplugins.common.LiquidTemplateRecipeHandler;
import mods.neiplugins.thaumcraft.TCUtils;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.EnumTag;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.crafting.RecipeCrucible;

public class CrucibleRecipeHandler
extends LiquidTemplateRecipeHandler {
    static final int xoffset = 27;
    static final int yoffset = -31;

    public String getRecipeName() {
        return "Cricuble";
    }

    @Override
    public String getRecipeId() {
        return "thaumcraft.crucible";
    }

    public String getGuiTexture() {
        return "/mods/thaumcraft/textures/gui/gui_researchbook_overlay.png";
    }

    public void drawBackground(GuiContainerManager gui, int recipe) {
        RecipeCrucible rc = ((CachedCrucibleRecipe)((Object)this.arecipes.get((int)recipe))).recipe;
        gui.bindTexture(this.getGuiTexture());
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glTranslatef((float)27.0f, (float)-3.0f, (float)0.0f);
        GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
        gui.drawTexturedModalRect(0, 0, 0, 3, 56, 64);
        gui.drawTexturedModalRect(40, 2, 68, 76, 12, 12);
        GL11.glPopMatrix();
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(107, 1, 24, 24), this.getRecipeId(), new Object[0]));
    }

    public void drawExtras(GuiContainerManager gui, int recipe) {
        RecipeCrucible rc = ((CachedCrucibleRecipe)((Object)this.arecipes.get((int)recipe))).recipe;
        gui.drawText(117, 16, rc.cost + " vis", -8355712, false);
        int total = 0;
        int rows = (rc.tags.size() - 1) / 3;
        int shift = (3 - rc.tags.size() % 3) * 10;
        int sx = 55;
        int sy = 65 - 10 * rows;
        for (EnumTag tag : rc.tags.getAspectsSorted()) {
            int m = 0;
            if (total / 3 >= rows && (rows > 1 || rc.tags.size() < 3)) {
                m = 1;
            }
            int vx = sx + total % 3 * 20 + shift * m;
            int vy = sy + total / 3 * 20;
            TCUtils.drawTag(gui.window, vx, vy, tag, rc.tags.getAmount(tag), false, true);
            ++total;
        }
    }

    @Override
    public List handleTooltip(GuiRecipe guiRecipe, List currenttip, int recipe) {
        currenttip = super.handleTooltip(guiRecipe, currenttip, recipe);
        RecipeCrucible rc = ((CachedCrucibleRecipe)((Object)this.arecipes.get((int)recipe))).recipe;
        Point mousepos = guiRecipe.manager.getMousePosition();
        Point offset = guiRecipe.getRecipePosition(recipe);
        Point relMouse = new Point(mousepos.x - guiRecipe.field_74198_m - offset.x, mousepos.y - guiRecipe.field_74197_n - offset.y);
        int total = 0;
        int rows = (rc.tags.size() - 1) / 3;
        int shift = (3 - rc.tags.size() % 3) * 10;
        int sx = 55;
        int sy = 65 - 10 * rows;
        for (EnumTag tag : rc.tags.getAspectsSorted()) {
            int m = 0;
            if (total / 3 >= rows && (rows > 1 || rc.tags.size() < 3)) {
                m = 1;
            }
            int vx = sx + total % 3 * 20 + shift * m;
            int vy = sy + total / 3 * 20;
            if (relMouse.x >= vx && relMouse.y >= vy && relMouse.x < vx + 16 && relMouse.y < vy + 16) {
                currenttip.add("\u00a7B" + tag.name);
                currenttip.add("\u00a77" + tag.meaning);
            }
            ++total;
        }
        return currenttip;
    }

    public int recipiesPerPage() {
        return 1;
    }

    public ArrayList getRecipeList() {
        ArrayList<RecipeCrucible> result = new ArrayList<RecipeCrucible>();
        for (Object recipe : ThaumcraftApi.getCrucibleRecipes()) {
            if (!(recipe instanceof RecipeCrucible) || !TCUtils.isResearchComplete(((RecipeCrucible)recipe).key)) continue;
            result.add((RecipeCrucible)recipe);
        }
        return result;
    }

    @Override
    public void loadSameRecipeId() {
        for (RecipeCrucible irecipe : this.getRecipeList()) {
            this.arecipes.add(new CachedCrucibleRecipe(irecipe));
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (RecipeCrucible irecipe : this.getRecipeList()) {
            if (!irecipe.recipeOutput.func_77969_a(result)) continue;
            this.arecipes.add(new CachedCrucibleRecipe(irecipe));
        }
    }

    public class CachedCrucibleRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public PositionedStack result;
        public RecipeCrucible recipe;

        public CachedCrucibleRecipe(RecipeCrucible irecipe) {
            super((TemplateRecipeHandler)CrucibleRecipeHandler.this);
            this.recipe = irecipe;
            this.result = new PositionedStack((Object)irecipe.recipeOutput, 75, 5);
        }

        public PositionedStack getIngredient() {
            return null;
        }

        public PositionedStack getResult() {
            return this.result;
        }
    }
}

