/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.te;

import java.util.HashMap;
import java.util.List;
import mods.neiplugins.common.FuelTooltip;
import mods.neiplugins.common.SimpleFuelContextHelper;
import mods.neiplugins.common.SimpleFuelHelper;
import mods.neiplugins.common.Utils;
import net.minecraft.item.ItemStack;
import net.minecraftforge.liquids.LiquidStack;
import thermalexpansion.api.ThermalExpansionInfo;

public class TEFuelHelper {
    public static void registerFuelHelpers() {
        FuelTooltip.addFuelHelper(true, new SimpleFuelHelper("te.steamengine", "Steam Engine", null){

            @Override
            public List getItemStackFuelTooltip(ItemStack stack, List currenttip) {
                int fuelValue = ThermalExpansionInfo.getFuelValue((ItemStack)stack);
                if (fuelValue > 0) {
                    currenttip.add("\u00a77" + fuelValue + " MJ (Steam Engine)");
                }
                return currenttip;
            }
        });
        FuelTooltip.addFuelHelper(new SimpleFuelHelper("te.magmaticengine", "Magmatic Engine", null){

            @Override
            public List getLiquidStackFuelTooltip(LiquidStack liquid, List currenttip) {
                int fuelValue = ThermalExpansionInfo.getFuelValue((LiquidStack)liquid);
                if (fuelValue > 0) {
                    fuelValue = fuelValue * liquid.amount / 1000;
                    currenttip.add("\u00a77" + fuelValue + " MJ (Magmatic Engine)");
                }
                return currenttip;
            }
        });
        HashMap<Class, String> map = new HashMap<Class, String>();
        Class cls = Utils.findClass("thermalexpansion.gui.gui.GuiEngineMagmatic");
        if (cls != null) {
            map.put(cls, "te.magmaticengine");
        }
        if ((cls = Utils.findClass("thermalexpansion.gui.gui.GuiEngineSteam")) != null) {
            map.put(cls, "te.steamengine");
        }
        if (!map.isEmpty()) {
            FuelTooltip.addContextFuelHelper(new SimpleFuelContextHelper("te.all", "Thermal Expansion", null, map));
        }
    }
}

