/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.forge;

import codechicken.nei.NEIClientUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.TreeSet;
import mods.neiplugins.NEIPlugins;
import mods.neiplugins.lists.GuiList;
import mods.neiplugins.lists.SimpleItemStackListElement;
import mods.neiplugins.lists.SimpleListElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

public class GuiGameRegistryModObjectTableList
extends GuiList {
    protected GuiGameRegistryModObjectTableList(GuiContainer prevgui, String title, ArrayList list) {
        super(prevgui, title, list);
    }

    public static ImmutableTable getModObjectTable() {
        try {
            Class<?> gameDataCls = Class.forName("cpw.mods.fml.common.registry.GameData");
            Field field = gameDataCls.getDeclaredField("modObjectTable");
            field.setAccessible(true);
            return (ImmutableTable)field.get(null);
        }
        catch (Exception ex) {
            NEIPlugins.logInfo("Failed to get field \"modObjectTable\" from class \"cpw.mods.fml.common.registry.GameData\": {0}", ex.getMessage());
            return null;
        }
    }

    public static boolean showList(String title) {
        Minecraft mc = NEIClientUtils.mc();
        if (!(mc.field_71462_r instanceof GuiContainer)) {
            return false;
        }
        GuiContainer prevscreen = (GuiContainer)mc.field_71462_r;
        ArrayList<ListElement1> list = new ArrayList<ListElement1>();
        for (String modId : new TreeSet(GuiGameRegistryModObjectTableList.getModObjectTable().rowKeySet())) {
            list.add(new ListElement1(modId));
        }
        if (list.isEmpty()) {
            return false;
        }
        NEIClientUtils.overlayScreen((GuiScreen)new GuiGameRegistryModObjectTableList(prevscreen, title, list));
        return true;
    }

    public static boolean showModRecipeList(String mod) {
        Minecraft mc = NEIClientUtils.mc();
        if (!(mc.field_71462_r instanceof GuiContainer)) {
            return false;
        }
        GuiContainer prevscreen = (GuiContainer)mc.field_71462_r;
        ImmutableTable modObjectTable = GuiGameRegistryModObjectTableList.getModObjectTable();
        if (!modObjectTable.containsRow((Object)mod)) {
            return false;
        }
        ArrayList<SimpleItemStackListElement> list = new ArrayList<SimpleItemStackListElement>();
        ImmutableMap map = modObjectTable.row((Object)mod);
        for (String key : new TreeSet(map.keySet())) {
            list.add(new SimpleItemStackListElement(key, new ItemStack(((Integer)map.get(key)).intValue(), 1, 0)));
        }
        if (list.isEmpty()) {
            return false;
        }
        NEIClientUtils.overlayScreen((GuiScreen)new GuiGameRegistryModObjectTableList(prevscreen, mod, list));
        return true;
    }

    static class ListElement1
    extends SimpleListElement {
        ListElement1(String title) {
            super(title);
        }

        @Override
        public boolean click(int button) {
            return GuiGameRegistryModObjectTableList.showModRecipeList(this.title);
        }
    }
}

