/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.forge;

import codechicken.nei.NEIClientUtils;
import com.google.common.collect.Table;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeSet;
import mods.neiplugins.NEIPlugins;
import mods.neiplugins.lists.GuiList;
import mods.neiplugins.lists.SimpleItemStackListElement;
import mods.neiplugins.lists.SimpleListElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

public class GuiGameRegistryCustomItemStackList
extends GuiList {
    protected GuiGameRegistryCustomItemStackList(GuiContainer prevgui, String title, ArrayList list) {
        super(prevgui, title, list);
    }

    public static Table getCustomItemStacks() {
        try {
            Class<?> gameDataCls = Class.forName("cpw.mods.fml.common.registry.GameData");
            Field field = gameDataCls.getDeclaredField("customItemStacks");
            field.setAccessible(true);
            return (Table)field.get(null);
        }
        catch (Exception ex) {
            NEIPlugins.logInfo("Failed to get field \"customItemStacks\" from class \"cpw.mods.fml.common.registry.GameData\": {0}", ex.getMessage());
            return null;
        }
    }

    public static boolean showList(String title) {
        Minecraft mc = NEIClientUtils.mc();
        if (!(mc.field_71462_r instanceof GuiContainer)) {
            return false;
        }
        GuiContainer prevscreen = (GuiContainer)mc.field_71462_r;
        ArrayList<ListElement1> list = new ArrayList<ListElement1>();
        for (String modId : new TreeSet(GuiGameRegistryCustomItemStackList.getCustomItemStacks().rowKeySet())) {
            list.add(new ListElement1(modId));
        }
        if (list.isEmpty()) {
            return false;
        }
        NEIClientUtils.overlayScreen((GuiScreen)new GuiGameRegistryCustomItemStackList(prevscreen, title, list));
        return true;
    }

    public static boolean showModRecipeList(String mod) {
        Minecraft mc = NEIClientUtils.mc();
        if (!(mc.field_71462_r instanceof GuiContainer)) {
            return false;
        }
        GuiContainer prevscreen = (GuiContainer)mc.field_71462_r;
        Table customItemStacks = GuiGameRegistryCustomItemStackList.getCustomItemStacks();
        if (!customItemStacks.containsRow((Object)mod)) {
            return false;
        }
        ArrayList<SimpleItemStackListElement> list = new ArrayList<SimpleItemStackListElement>();
        Map map = customItemStacks.row((Object)mod);
        for (String key : new TreeSet(map.keySet())) {
            list.add(new SimpleItemStackListElement(key, (ItemStack)map.get(key)));
        }
        if (list.isEmpty()) {
            return false;
        }
        NEIClientUtils.overlayScreen((GuiScreen)new GuiGameRegistryCustomItemStackList(prevscreen, mod, list));
        return true;
    }

    static class ListElement1
    extends SimpleListElement {
        ListElement1(String title) {
            super(title);
        }

        @Override
        public boolean click(int button) {
            return GuiGameRegistryCustomItemStackList.showModRecipeList(this.title);
        }
    }
}

