/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.forestry;

import forestry.api.fuels.EngineBronzeFuel;
import forestry.api.fuels.EngineCopperFuel;
import forestry.api.fuels.FuelManager;
import forestry.api.fuels.GeneratorFuel;
import java.util.List;
import mods.neiplugins.common.FuelTooltip;
import mods.neiplugins.common.SimpleFuelHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.liquids.LiquidStack;

public class ForestryFuelHelper {
    public static void registerFuelHelpers() {
        FuelTooltip.addFuelHelper(new SimpleFuelHelper("forestry.copperengine", "Peat-fired Engine", null){

            @Override
            public List getItemStackFuelTooltip(ItemStack stack, List currenttip) {
                EngineCopperFuel copperFuel = (EngineCopperFuel)FuelManager.copperEngineFuel.get(stack);
                if (copperFuel != null) {
                    currenttip.add("\u00a77" + FuelTooltip.convertMJt(copperFuel.powerPerCycle) + " MJ/t for " + copperFuel.burnDuration + " ticks (" + "Peat-fired Engine" + ")");
                }
                return currenttip;
            }
        });
        FuelTooltip.addFuelHelper(new SimpleFuelHelper("forestry.bronzeengine", "Biogas Engine", null){

            @Override
            public List getLiquidStackFuelTooltip(LiquidStack liquid, List currenttip) {
                EngineBronzeFuel bronzeFuel = (EngineBronzeFuel)FuelManager.bronzeEngineFuel.get(liquid);
                if (bronzeFuel != null) {
                    currenttip.add("\u00a77" + FuelTooltip.convertMJt(bronzeFuel.powerPerCycle) + " MJ/t for " + bronzeFuel.burnDuration * liquid.amount / 1000 + " ticks (" + "Biogas Engine" + ")");
                }
                return currenttip;
            }
        });
        FuelTooltip.addFuelHelper(new SimpleFuelHelper("forestry.generator", "Bio Generator", null){

            @Override
            public List getLiquidStackFuelTooltip(LiquidStack liquid, List currenttip) {
                GeneratorFuel generatorFuel = (GeneratorFuel)GeneratorFuel.fuels.get(liquid.itemID);
                if (generatorFuel != null) {
                    currenttip.add("\u00a77" + FuelTooltip.compactValueF(liquid.amount * generatorFuel.eu * generatorFuel.rate / generatorFuel.fuelConsumed.amount) + " EU at " + generatorFuel.eu + " EU/t (" + "Bio Generator" + ")");
                }
                return currenttip;
            }
        });
    }
}

