/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.common;

import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.logging.Level;
import mods.neiplugins.NEIPlugins;
import mods.neiplugins.common.RecipeHandlerUtils;
import mods.neiplugins.common.TickHandlerIMCMessages;

public abstract class IMCHandler {
    private static TickHandlerIMCMessages handleIMCMessages;

    public static void postInit() {
        handleIMCMessages = new TickHandlerIMCMessages();
        handleIMCMessages.reset();
        TickRegistry.registerScheduledTickHandler((IScheduledTickHandler)handleIMCMessages, (Side)Side.SERVER);
    }

    public static void processIMCMessage(FMLInterModComms.IMCMessage message) {
        NEIPlugins.logFine("Accepted IMC message {0} with type {1}", message.key, message.getMessageType().getName());
        if (message.key.equals("register-usage-handler")) {
            String[] tokens = message.getStringValue().split("@");
            if (tokens.length != 3) {
                NEIPlugins.log(Level.INFO, String.format("Received an invalid 'register-usage-handler' request %s from mod %s", message.getStringValue(), message.getSender()), new Object[0]);
                return;
            }
            if (!RecipeHandlerUtils.addToRecipeList(tokens[0], tokens[1], 1, tokens[2], new Object[0])) {
                NEIPlugins.log(Level.INFO, String.format("Received 'register-usage-handler' request %s from mod %s for recipe ID that already registred", message.getStringValue(), message.getSender()), new Object[0]);
                return;
            }
        } else if (message.key.equals("register-crafting-handler")) {
            String[] tokens = message.getStringValue().split("@");
            if (tokens.length != 3) {
                NEIPlugins.log(Level.INFO, String.format("Received an invalid 'register-crafting-handler' request %s from mod %s", message.getStringValue(), message.getSender()), new Object[0]);
                return;
            }
            if (!RecipeHandlerUtils.addToRecipeList(tokens[0], tokens[1], 0, tokens[2], new Object[0])) {
                NEIPlugins.log(Level.INFO, String.format("Received 'register-crafting-handler' request %s from mod %s for recipe ID that already registred", message.getStringValue(), message.getSender()), new Object[0]);
                return;
            }
        }
    }
}

