/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import mods.neiplugins.common.IMCHandler;
import mods.neiplugins.common.IPlugin;
import mods.neiplugins.common.Utils;
import mods.neiplugins.options.OptionsNEIPlugins;

@Mod(modid="NEIPlugins", name="NEI Plugins", version="1.0.9.3", dependencies="required-after:NotEnoughItems@[1.5.2.16,)")
public class NEIPlugins {
    public static final String VERSION = "1.0.9.3";
    public static Logger logger = Logger.getLogger("NEIPlugins");
    @Mod.Instance(value="NEIPlugins")
    private static NEIPlugins instance;
    private ModMetadata modMetadata;
    public File modLocation;
    public Map plugins;
    public Map pluginsState;
    public Map modVersions;

    public static NEIPlugins getMod() {
        return instance;
    }

    public boolean hasMod(ArtifactVersion modVersion) {
        return this.modVersions.containsKey(modVersion.getLabel()) && modVersion.containsVersion((ArtifactVersion)this.modVersions.get(modVersion.getLabel()));
    }

    public boolean hasMod(String modVersion) {
        return this.hasMod(VersionParser.parseVersionReference((String)modVersion));
    }

    public static void log(Level level, String msg, Object ... params) {
        logger.log(level, Utils.logFormat(msg, params));
    }

    public static void logEx(Level level, String msg, Exception ex, Object ... params) {
        logger.log(level, Utils.logFormat(msg, params), ex);
    }

    public static void logWarningEx(String msg, Exception ex, Object ... params) {
        NEIPlugins.logEx(Level.WARNING, msg, ex, params);
    }

    public static void logWarning(String msg, Object ... params) {
        NEIPlugins.log(Level.WARNING, msg, params);
    }

    public static void logInfo(String msg, Object ... params) {
        NEIPlugins.log(Level.INFO, msg, params);
    }

    public static void logFine(String msg, Object ... params) {
        NEIPlugins.log(Level.FINE, msg, params);
    }

    private void loadPlugins() {
        ClassLoader classLoader = NEIPlugins.class.getClassLoader();
        if (this.modLocation.isFile() && (this.modLocation.getName().endsWith(".jar") || this.modLocation.getName().endsWith(".zip"))) {
            this.loadPluginsFromFile(this.modLocation, classLoader);
        } else if (this.modLocation.isDirectory()) {
            this.loadPluginsFromBin(this.modLocation, this.modLocation.getPath() + File.separatorChar, classLoader);
        }
    }

    private void loadPluginsFromFile(File file, ClassLoader classLoader) {
        try {
            ZipEntry entry = null;
            FileInputStream fileIO = new FileInputStream(this.modLocation);
            ZipInputStream zipIO = new ZipInputStream(fileIO);
            while (true) {
                if ((entry = zipIO.getNextEntry()) == null) {
                    fileIO.close();
                    break;
                }
                String entryName = entry.getName();
                File entryFile = new File(entryName);
                String pluginName = entryFile.getName();
                if (entry.isDirectory() || !pluginName.startsWith("NEIPlugins_") || !pluginName.endsWith(".class") || pluginName.indexOf(36) != -1) continue;
                this.addPlugin(classLoader, pluginName, entryFile.getParent());
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void loadPluginsFromBin(File bin, String basePath, ClassLoader classLoader) {
        File[] fileList = bin.listFiles();
        if (fileList != null) {
            for (File file : fileList) {
                String pluginName = file.getName();
                if (file.isFile() && pluginName.startsWith("NEIPlugins_") && pluginName.endsWith(".class") && pluginName.indexOf(36) == -1) {
                    String dirPath = file.getParent();
                    if (!dirPath.startsWith(basePath)) continue;
                    dirPath = dirPath.substring(basePath.length());
                    this.addPlugin(classLoader, pluginName, dirPath);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.loadPluginsFromBin(file, basePath, classLoader);
            }
        }
    }

    private void updateModMetadata() {
        String pluginslist = "Available plugins:";
        for (String pluginName : this.pluginsState.keySet()) {
            IPlugin plugin = (IPlugin)this.plugins.get(pluginName);
            pluginslist = pluginslist + "\n " + ((EnumPluginState)((Object)this.pluginsState.get(pluginName))).getColorPrefix() + plugin.getPluginName() + " (" + plugin.getPluginVersion() + ")";
        }
        this.modMetadata.description = this.pluginsState.size() > 0 ? pluginslist : "No plugins detected.";
    }

    public void addPlugin(ClassLoader classLoader, String pluginName, String dirPath) {
        if (dirPath == null) {
            NEIPlugins.logWarning("Invalid addPlugin call for plugin \"{0}\"", pluginName);
            return;
        }
        String pluginClassName = dirPath.replace(File.separatorChar, '.') + '.' + pluginName.split("\\.")[0];
        try {
            Class<?> pluginClass = classLoader.loadClass(pluginClassName);
            if (pluginClass != null) {
                Object obj = pluginClass.newInstance();
                if (!(obj instanceof IPlugin)) {
                    return;
                }
                IPlugin plugin = (IPlugin)obj;
                NEIPlugins.logFine("Found NEIPlugins plugin {0} ({1})", plugin.getPluginName(), plugin.getPluginVersion());
                this.plugins.put(plugin.getPluginName(), plugin);
            }
        }
        catch (NoClassDefFoundError ex) {
            NEIPlugins.logWarning("Error while detecting plugin: Class {0} not found " + pluginName, ex.getMessage());
        }
        catch (Exception ex) {
            NEIPlugins.logWarningEx("Error while detecting plugin " + pluginName, ex, new Object[0]);
        }
    }

    public void initPlugins() {
        this.pluginsState.clear();
        for (IPlugin plugin : this.plugins.values()) {
            block8: {
                this.pluginsState.put(plugin.getPluginName(), EnumPluginState.INACTIVE);
                try {
                    if (!plugin.isValid()) {
                        NEIPlugins.logFine("Plugin {0} ({1}) not active", plugin.getPluginName(), plugin.getPluginVersion());
                    }
                    break block8;
                }
                catch (NoClassDefFoundError ex) {
                    NEIPlugins.logWarning("Error while calling isValid() for plugin \"{0} ({1})\": {2}", plugin.getPluginName(), plugin.getPluginVersion(), ex.getMessage());
                    this.pluginsState.put(plugin.getPluginName(), EnumPluginState.ERROR);
                }
                catch (Exception ex) {
                    NEIPlugins.logWarningEx("Error while calling isValid() for plugin \"{0} ({1})\"", ex, plugin.getPluginName(), plugin.getPluginVersion());
                    this.pluginsState.put(plugin.getPluginName(), EnumPluginState.ERROR);
                }
                continue;
            }
            try {
                plugin.init();
                this.pluginsState.put(plugin.getPluginName(), EnumPluginState.POSTINIT);
            }
            catch (NoClassDefFoundError ex) {
                NEIPlugins.logWarning("Error while calling init() for plugin \"{0} ({1})\": {2}", plugin.getPluginName(), plugin.getPluginVersion(), ex.getMessage());
                this.pluginsState.put(plugin.getPluginName(), EnumPluginState.ERROR);
            }
            catch (Exception ex) {
                NEIPlugins.logWarningEx("Error while calling init() for plugin \"{0} ({1})\"", ex, plugin.getPluginName(), plugin.getPluginVersion());
                this.pluginsState.put(plugin.getPluginName(), EnumPluginState.ERROR);
            }
        }
        this.updateModMetadata();
    }

    public void loadConfig() {
        for (String pluginName : this.pluginsState.keySet()) {
            if (this.pluginsState.get(pluginName) != EnumPluginState.POSTINIT) continue;
            IPlugin plugin = (IPlugin)this.plugins.get(pluginName);
            try {
                plugin.loadConfig();
                this.pluginsState.put(pluginName, EnumPluginState.CLIENTINIT);
            }
            catch (NoClassDefFoundError ex) {
                NEIPlugins.logWarning("Error while calling loadConfig() for plugin \"{0} ({1})\": {2}", plugin.getPluginName(), plugin.getPluginVersion(), ex.getMessage());
                this.pluginsState.put(pluginName, EnumPluginState.ERROR);
            }
            catch (Exception ex) {
                NEIPlugins.logWarningEx("Error while calling loadConfig() for plugin \"{0} ({1})\"", ex, plugin.getPluginName(), plugin.getPluginVersion());
                this.pluginsState.put(pluginName, EnumPluginState.ERROR);
            }
        }
        this.updateModMetadata();
        OptionsNEIPlugins.addOptions();
    }

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent evt) {
        this.modLocation = evt.getSourceFile();
        this.plugins = new HashMap();
        this.pluginsState = new HashMap();
        this.modVersions = new HashMap();
    }

    @Mod.Init
    public void init(FMLInitializationEvent event) {
        this.modMetadata = Loader.instance().activeModContainer().getMetadata();
    }

    @Mod.PostInit
    public void postInit(FMLPostInitializationEvent evt) {
        for (ModContainer mod : Loader.instance().getActiveModList()) {
            this.modVersions.put(mod.getModId(), mod.getProcessedVersion());
        }
        this.loadPlugins();
        this.initPlugins();
        IMCHandler.postInit();
    }

    @Mod.IMCCallback
    public void processIMCMessages(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            IMCHandler.processIMCMessage(message);
        }
    }

    static {
        logger.setParent(FMLCommonHandler.instance().getFMLLogger());
    }

    public static enum EnumPluginState {
        ERROR("\u00a7c"),
        INACTIVE("\u00a77"),
        POSTINIT("\u00a76"),
        CLIENTINIT("\u00a7a");

        private final String colorPrefix;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private EnumPluginState() {
            void colorPrefix;
            this.colorPrefix = colorPrefix;
        }

        public String getColorPrefix() {
            return this.colorPrefix;
        }
    }
}

