/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import ic2.api.Direction;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.core.ExplosionIC2;
import ic2.core.IC2;
import ic2.core.ITickCallback;
import ic2.core.Ic2Items;
import ic2.core.block.wiring.TileEntityCable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class TileEntityLuminator
extends TileEntity
implements IEnergySink {
    public int energy = 0;
    public int ticker = -1;
    public boolean ignoreBlockStay = false;
    public int maxInput = 32;
    public boolean addedToEnergyNet = false;
    private boolean loaded = false;

    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.energy = nbttagcompound.func_74765_d("energy");
    }

    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74777_a("energy", (short)this.energy);
    }

    public void func_70312_q() {
        super.func_70312_q();
        IC2.addSingleTickCallback(this.field_70331_k, new ITickCallback(){

            @Override
            public void tickCallback(World world) {
                if (TileEntityLuminator.this.func_70320_p() || !world.func_72899_e(TileEntityLuminator.this.field_70329_l, TileEntityLuminator.this.field_70330_m, TileEntityLuminator.this.field_70327_n)) {
                    return;
                }
                TileEntityLuminator.this.onLoaded();
                if (TileEntityLuminator.this.enableUpdateEntity()) {
                    world.field_73009_h.add(TileEntityLuminator.this);
                }
            }
        });
    }

    public void func_70313_j() {
        super.func_70313_j();
        if (this.loaded) {
            this.onUnloaded();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.loaded) {
            this.onUnloaded();
        }
    }

    public void onLoaded() {
        if (IC2.platform.isSimulating() && !this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
        this.loaded = true;
    }

    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
    }

    public final boolean canUpdate() {
        return false;
    }

    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public void func_70316_g() {
        ++this.ticker;
        if (this.ticker % 4 == 0) {
            --this.energy;
            if (this.energy <= 0) {
                this.field_70331_k.func_72832_d(this.field_70329_l, this.field_70330_m, this.field_70327_n, Ic2Items.luminator.field_77993_c, this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n), 7);
            }
        }
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.addedToEnergyNet;
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, Direction direction) {
        return emitter instanceof TileEntityCable;
    }

    @Override
    public int demandsEnergy() {
        return this.getMaxEnergy() - this.energy;
    }

    @Override
    public int injectEnergy(Direction directionFrom, int amount) {
        if (amount > this.maxInput) {
            this.poof();
            return 0;
        }
        if (this.energy >= this.getMaxEnergy() || amount <= 0) {
            return amount;
        }
        if (this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n) == Ic2Items.luminator.field_77993_c) {
            this.field_70331_k.func_72832_d(this.field_70329_l, this.field_70330_m, this.field_70327_n, Ic2Items.activeLuminator.field_77993_c, this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n), 7);
            TileEntityLuminator newLumi = (TileEntityLuminator)this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            return newLumi.injectEnergy(directionFrom, amount);
        }
        this.energy += amount;
        return 0;
    }

    @Override
    public int getMaxSafeInput() {
        return this.maxInput;
    }

    public int getMaxEnergy() {
        return 10000;
    }

    public void poof() {
        this.field_70331_k.func_72832_d(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0, 0, 7);
        ExplosionIC2 explosion = new ExplosionIC2(this.field_70331_k, null, 0.5 + (double)this.field_70329_l, 0.5 + (double)this.field_70330_m, 0.5 + (double)this.field_70327_n, 0.5f, 0.85f, 2.0f);
        explosion.doExplosion();
    }

    public boolean canCableConnectFrom(int x, int y, int z) {
        int facing = this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        switch (facing) {
            case 0: {
                return x == this.field_70329_l && y == this.field_70330_m + 1 && z == this.field_70327_n;
            }
            case 1: {
                return x == this.field_70329_l && y == this.field_70330_m - 1 && z == this.field_70327_n;
            }
            case 2: {
                return x == this.field_70329_l && y == this.field_70330_m && z == this.field_70327_n + 1;
            }
            case 3: {
                return x == this.field_70329_l && y == this.field_70330_m && z == this.field_70327_n - 1;
            }
            case 4: {
                return x == this.field_70329_l + 1 && y == this.field_70330_m && z == this.field_70327_n;
            }
            case 5: {
                return x == this.field_70329_l - 1 && y == this.field_70330_m && z == this.field_70327_n;
            }
        }
        return false;
    }
}

