/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.Direction;
import ic2.api.recipe.Recipes;
import ic2.core.ContainerBase;
import ic2.core.ExplosionIC2;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.invslot.InvSlotProcessableGeneric;
import ic2.core.block.machine.ContainerMatter;
import ic2.core.block.machine.gui.GuiMatter;
import ic2.core.block.machine.tileentity.TileEntityElectricMachine;
import java.util.List;
import java.util.Vector;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityMatter
extends TileEntityElectricMachine
implements IHasGui {
    public int soundTicker = IC2.random.nextInt(32);
    public int scrap = 0;
    private final int StateIdle = 0;
    private final int StateRunning = 1;
    private final int StateRunningScrap = 2;
    private int state = 0;
    private int prevState = 0;
    private AudioSource audioSource;
    private AudioSource audioSourceScrap;
    public final InvSlotProcessableGeneric amplifierSlot = new InvSlotProcessableGeneric((TileEntityInventory)this, "scrap", 0, 1, Recipes.matterAmplifier);
    public final InvSlotOutput outputSlot = new InvSlotOutput(this, "output", 1, 1);

    public TileEntityMatter() {
        super(1000000, 3, -1);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        try {
            this.scrap = nbttagcompound.func_74762_e("scrap");
        }
        catch (Throwable e) {
            this.scrap = nbttagcompound.func_74765_d("scrap");
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74768_a("scrap", this.scrap);
    }

    @Override
    public String func_70303_b() {
        return "Mass Fabricator";
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (this.isRedstonePowered() || this.energy <= 0) {
            this.setState(0);
            this.setActive(false);
        } else {
            Integer amplifier;
            this.setState(this.scrap > 0 ? 2 : 1);
            this.setActive(true);
            boolean needsInvUpdate = false;
            if (this.scrap < 1000 && (amplifier = (Integer)this.amplifierSlot.processRaw(false)) != null && amplifier > 0) {
                this.scrap += amplifier.intValue();
            }
            if (this.energy >= 1000000) {
                needsInvUpdate = this.attemptGeneration();
            }
            if (needsInvUpdate) {
                this.func_70296_d();
            }
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources(this);
            this.audioSource = null;
            this.audioSourceScrap = null;
        }
        super.onUnloaded();
    }

    public boolean attemptGeneration() {
        if (this.outputSlot.add(Ic2Items.matter.func_77946_l()) == 0) {
            this.energy -= 1000000;
            return true;
        }
        return false;
    }

    @Override
    public int demandsEnergy() {
        if (this.isRedstonePowered()) {
            return 0;
        }
        return this.maxEnergy - this.energy;
    }

    @Override
    public int injectEnergy(Direction directionFrom, int amount) {
        if (amount > this.getMaxSafeInput()) {
            this.field_70331_k.func_72832_d(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0, 0, 7);
            ExplosionIC2 explosion = new ExplosionIC2(this.field_70331_k, null, (float)this.field_70329_l + 0.5f, (float)this.field_70330_m + 0.5f, (float)this.field_70327_n + 0.5f, 15.0f, 0.01f, 1.5f);
            explosion.doExplosion();
            return 0;
        }
        if (this.energy >= this.maxEnergy || this.isRedstonePowered()) {
            return amount;
        }
        int bonus = Math.max(amount, this.scrap);
        this.scrap -= bonus;
        this.energy += amount + 5 * bonus;
        return 0;
    }

    @Override
    public int getMaxSafeInput() {
        return 512;
    }

    public String getProgressAsString() {
        int p = this.energy / 10000;
        if (p > 100) {
            p = 100;
        }
        return "" + p + "%";
    }

    @Override
    public ContainerBase getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerMatter(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiMatter(new ContainerMatter(entityPlayer, this));
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    private void setState(int state) {
        this.state = state;
        if (this.prevState != state) {
            IC2.network.updateTileEntityField(this, "state");
        }
        this.prevState = state;
    }

    @Override
    public List getNetworkedFields() {
        Vector<String> ret = new Vector<String>(1);
        ret.add("state");
        ret.addAll(super.getNetworkedFields());
        return ret;
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("state") && this.prevState != this.state) {
            switch (this.state) {
                case 0: {
                    if (this.audioSource != null) {
                        this.audioSource.stop();
                    }
                    if (this.audioSourceScrap == null) break;
                    this.audioSourceScrap.stop();
                    break;
                }
                case 1: {
                    if (this.audioSource == null) {
                        this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, "Generators/MassFabricator/MassFabLoop.ogg", true, false, IC2.audioManager.defaultVolume);
                    }
                    if (this.audioSource != null) {
                        this.audioSource.play();
                    }
                    if (this.audioSourceScrap == null) break;
                    this.audioSourceScrap.stop();
                    break;
                }
                case 2: {
                    if (this.audioSource == null) {
                        this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, "Generators/MassFabricator/MassFabLoop.ogg", true, false, IC2.audioManager.defaultVolume);
                    }
                    if (this.audioSourceScrap == null) {
                        this.audioSourceScrap = IC2.audioManager.createSource(this, PositionSpec.Center, "Generators/MassFabricator/MassFabScrapSolo.ogg", true, false, IC2.audioManager.defaultVolume);
                    }
                    if (this.audioSource != null) {
                        this.audioSource.play();
                    }
                    if (this.audioSourceScrap == null) break;
                    this.audioSourceScrap.play();
                }
            }
            this.prevState = this.state;
        }
        super.onNetworkUpdate(field);
    }

    @Override
    public float getWrenchDropRate() {
        return 0.7f;
    }

    public boolean amplificationIsAvailable() {
        if (this.scrap > 0) {
            return true;
        }
        Integer amplifier = (Integer)this.amplifierSlot.processRaw(false);
        return amplifier != null && amplifier > 0;
    }
}

